/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.interceptor;

import com.contentful.java.cma.interceptor.RateLimitsListener;
import com.contentful.java.cma.model.RateLimits;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Response;

public class RateLimitInterceptor
implements Interceptor {
    final RateLimitsListener listener;

    public RateLimitInterceptor(RateLimitsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null!");
        }
        this.listener = listener;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        Headers headers = response.headers();
        Map mappedHeaders = headers.toMultimap();
        RateLimits limits = new RateLimits.DefaultParser().parse(mappedHeaders);
        this.listener.onRateLimitHeaderReceived(limits);
        return response;
    }
}

