/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMAMetadata;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;
import java.util.LinkedHashMap;

public class CMAEntry
extends CMAResource {
    LinkedHashMap<String, LinkedHashMap<String, Object>> fields;
    public CMAMetadata metadata;

    public CMAEntry() {
        super(CMAType.Entry);
    }

    public CMAEntry setSystem(CMASystem system) {
        this.system = system;
        return this;
    }

    public CMAEntry setId(String id) {
        return (CMAEntry)super.setId(id);
    }

    public CMAEntry setVersion(Integer version) {
        return (CMAEntry)super.setVersion(version);
    }

    public CMAEntry setSpaceId(String spaceId) {
        return (CMAEntry)super.setSpaceId(spaceId);
    }

    public CMAEntry setEnvironmentId(String environmentId) {
        return (CMAEntry)super.setEnvironmentId(environmentId);
    }

    public CMAEntry setField(String key, String locale, Object value) {
        LinkedHashMap<String, Object> field;
        if (this.fields == null) {
            this.fields = new LinkedHashMap();
        }
        if ((field = this.fields.get(key)) == null) {
            field = new LinkedHashMap();
        }
        field.put(locale, value);
        this.fields.put(key, field);
        return this;
    }

    public <T> T getField(String key, String locale) {
        if (this.fields == null) {
            return null;
        }
        LinkedHashMap<String, Object> field = this.fields.get(key);
        if (field == null) {
            return null;
        }
        return (T)field.get(locale);
    }

    public LinkedHashMap<String, LinkedHashMap<String, Object>> getFields() {
        return this.fields;
    }

    public CMAMetadata getMetadata() {
        return this.metadata;
    }

    public CMAEntry setMetadata(CMAMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public CMAEntry setFields(LinkedHashMap<String, LinkedHashMap<String, Object>> fields) {
        this.fields = fields;
        return this;
    }

    public Localized localize(String locale) {
        return new Localized(locale);
    }

    @Override
    public String toString() {
        return "CMAEntry { " + super.toString() + " fields = " + this.getFields() + " metadata = " + this.getMetadata() + " }";
    }

    public class Localized {
        private final String locale;

        Localized(String locale) {
            this.locale = locale;
        }

        public <T> T getField(String key) {
            return CMAEntry.this.getField(key, this.locale);
        }

        public <T> Localized setField(String key, T value) {
            CMAEntry.this.setField(key, this.locale, value);
            return this;
        }

        public String toString() {
            return "Localized { locale = " + this.locale + ", fields = " + CMAEntry.this.fields + " }";
        }
    }
}

