/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMALink;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMAType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CMASpaceMembership
extends CMAResource {
    private boolean admin;
    private CMALink user;
    private List<CMALink> roles;
    private String email;

    public CMASpaceMembership() {
        super(CMAType.SpaceMembership);
    }

    public CMALink getUser() {
        return this.user;
    }

    public CMASpaceMembership setUser(CMALink user) {
        this.user = user;
        return this;
    }

    public List<CMALink> getRoles() {
        return this.roles;
    }

    public CMASpaceMembership setRoles(CMALink ... roles) {
        if (roles == null) {
            throw new IllegalArgumentException("Roles cannot be null!");
        }
        if (roles.length <= 0) {
            throw new IllegalArgumentException("Roles cannot be empty!");
        }
        this.roles = new ArrayList<CMALink>(Arrays.asList(roles));
        return this;
    }

    public CMASpaceMembership addRole(CMALink role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null!");
        }
        if (this.roles == null) {
            this.roles = new ArrayList<CMALink>();
        }
        this.roles.add(role);
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CMASpaceMembership setEmail(String email) {
        if (email == null) {
            throw new IllegalArgumentException("email cannot be null.");
        }
        if (!email.contains("@")) {
            throw new IllegalArgumentException("email needs to contain an '@' symbol.");
        }
        this.email = email;
        return this;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public CMASpaceMembership setAdmin(boolean admin) {
        this.admin = admin;
        return this;
    }

    public CMASpaceMembership setIsAdmin(boolean admin) {
        this.admin = admin;
        return this;
    }

    public CMASpaceMembership setId(String id) {
        return (CMASpaceMembership)super.setId(id);
    }

    public CMASpaceMembership setVersion(Integer version) {
        return (CMASpaceMembership)super.setVersion(version);
    }

    public CMASpaceMembership setSpaceId(String id) {
        return (CMASpaceMembership)super.setSpaceId(id);
    }

    @Override
    public String toString() {
        return "CMASpaceMembership { " + super.toString() + " admin = " + this.isAdmin() + ", email = " + this.getEmail() + ", roles = " + this.getRoles() + ", user = " + this.getUser() + " }";
    }
}

