/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model.rich;

import com.contentful.java.cma.model.rich.CMARichMark;
import com.contentful.java.cma.model.rich.CMARichNode;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CMARichText
extends CMARichNode {
    @NonNull
    private List<CMARichMark> marks = new ArrayList<CMARichMark>();
    @NonNull
    private CharSequence value;

    public CMARichText(@NonNull CharSequence value, @NonNull List<CMARichMark> marks) {
        super("text");
        if (value == null) {
            throw new NullPointerException("value was null");
        }
        if (marks == null) {
            throw new NullPointerException("marks is null");
        }
        this.marks.addAll(marks);
        this.value = value;
    }

    public CMARichText(@NonNull String value) {
        this(value, Collections.emptyList());
    }

    @NonNull
    public CharSequence getValue() {
        return this.value;
    }

    @NonNull
    public CMARichText setValue(@NonNull CharSequence value) {
        if (value == null) {
            throw new NullPointerException("value is null.");
        }
        this.value = value;
        return this;
    }

    @NonNull
    public List<CMARichMark> getMarks() {
        return this.marks;
    }

    @NonNull
    public CMARichText addMarks(CMARichMark ... marks) {
        this.marks.addAll(Arrays.asList(marks));
        return this;
    }

    @NonNull
    public CMARichText setMarks(@NonNull List<CMARichMark> marks) {
        this.marks.clear();
        this.marks.addAll(marks);
        return this;
    }
}

