/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceEnvironments;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAEnvironment;
import com.contentful.java.cma.model.CMASystem;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleEnvironments
extends AbsModule<ServiceEnvironments> {
    final Async async = new Async();

    public ModuleEnvironments(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceEnvironments createService(Retrofit retrofit) {
        return (ServiceEnvironments)retrofit.create(ServiceEnvironments.class);
    }

    public CMAEnvironment create(CMAEnvironment environment) {
        return this.create(this.spaceId, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEnvironment create(String spaceId, CMAEnvironment environment) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environment, "environment");
        String environmentId = environment.getId();
        CMASystem system = environment.getSystem();
        environment.setSystem(null);
        try {
            if (environmentId == null) {
                CMAEnvironment cMAEnvironment = (CMAEnvironment)((ServiceEnvironments)this.service).create(spaceId, environment).blockingFirst();
                return cMAEnvironment;
            }
            CMAEnvironment cMAEnvironment = (CMAEnvironment)((ServiceEnvironments)this.service).create(spaceId, environmentId, environment).blockingFirst();
            return cMAEnvironment;
        }
        finally {
            environment.setSystem(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEnvironment clone(CMAEnvironment sourceEnvironment, CMAEnvironment newEnvironment) {
        this.assertNotNull(sourceEnvironment, "sourceEnvironment");
        this.assertNotNull(newEnvironment, "newEnvironment");
        this.assertNotNull(sourceEnvironment.getSpaceId(), "sourceEnvironment.spaceId");
        String environmentId = newEnvironment.getId();
        CMASystem system = newEnvironment.getSystem();
        newEnvironment.setSystem(null);
        try {
            if (environmentId == null) {
                CMAEnvironment cMAEnvironment = (CMAEnvironment)((ServiceEnvironments)this.service).clone(this.spaceId, sourceEnvironment.getId(), newEnvironment).blockingFirst();
                return cMAEnvironment;
            }
            CMAEnvironment cMAEnvironment = (CMAEnvironment)((ServiceEnvironments)this.service).clone(this.spaceId, sourceEnvironment.getId(), environmentId, newEnvironment).blockingFirst();
            return cMAEnvironment;
        }
        finally {
            newEnvironment.setSystem(system);
        }
    }

    @Deprecated
    public CMAEnvironment branch(CMAEnvironment sourceEnvironment, CMAEnvironment newEnvironment) {
        return this.clone(sourceEnvironment, newEnvironment);
    }

    public Integer delete(CMAEnvironment environment) {
        this.assertNotNull(environment.getSpaceId(), "spaceId");
        this.assertNotNull(environment.getId(), "environmentId");
        return ((Response)((ServiceEnvironments)this.service).delete(this.getVersionOrThrow(environment, "version"), environment.getSpaceId(), environment.getId()).blockingFirst()).code();
    }

    public CMAArray<CMAEnvironment> fetchAll() {
        return this.fetchAll(this.spaceId);
    }

    public CMAArray<CMAEnvironment> fetchAll(String spaceId) {
        this.assertNotNull(spaceId, "spaceId");
        return (CMAArray)((ServiceEnvironments)this.service).fetchAll(spaceId).blockingFirst();
    }

    public CMAEnvironment fetchOne(String environmentId) {
        return this.fetchOne(this.spaceId, environmentId);
    }

    public CMAEnvironment fetchOne(String spaceId, String environmentId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        return (CMAEnvironment)((ServiceEnvironments)this.service).fetchOne(spaceId, environmentId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEnvironment update(CMAEnvironment environment) {
        this.assertNotNull(environment, "environment");
        this.assertNotNull(environment.getName(), "environment.name");
        String environmentId = this.getResourceIdOrThrow(environment, "environment id");
        Integer version = this.getVersionOrThrow(environment, "update");
        String spaceId = this.getSpaceIdOrThrow(environment, "environment");
        CMASystem system = environment.getSystem();
        environment.setSystem(null);
        try {
            CMAEnvironment cMAEnvironment = (CMAEnvironment)((ServiceEnvironments)this.service).update(version, spaceId, environmentId, environment).blockingFirst();
            return cMAEnvironment;
        }
        finally {
            environment.setSystem(system);
        }
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAEnvironment> create(final CMAEnvironment environment, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.create(environment);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> create(final String spaceId, final CMAEnvironment environment, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.create(spaceId, environment);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> clone(final CMAEnvironment sourceEnvironment, final CMAEnvironment newEnvironment, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.clone(sourceEnvironment, newEnvironment);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> branch(final CMAEnvironment sourceEnvironment, final CMAEnvironment newEnvironment, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.branch(sourceEnvironment, newEnvironment);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAEnvironment environment, CMACallback<Integer> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleEnvironments.this.delete(environment);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEnvironment>> fetchAll(CMACallback<CMAArray<CMAEnvironment>> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEnvironment>>(){

                @Override
                CMAArray<CMAEnvironment> method() {
                    return ModuleEnvironments.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEnvironment>> fetchAll(final String spaceId, CMACallback<CMAArray<CMAEnvironment>> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEnvironment>>(){

                @Override
                CMAArray<CMAEnvironment> method() {
                    return ModuleEnvironments.this.fetchAll(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> fetchOne(final String environmentId, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.fetchOne(environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> fetchOne(final String spaceId, final String environmentId, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.fetchOne(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAEnvironment> update(final CMAEnvironment environment, CMACallback<CMAEnvironment> callback) {
            return ModuleEnvironments.this.defer(new RxExtensions.DefFunc<CMAEnvironment>(){

                @Override
                CMAEnvironment method() {
                    return ModuleEnvironments.this.update(environment);
                }
            }, callback);
        }
    }
}

