/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.DefaultQueryParameter;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceContentTags;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMATag;
import com.contentful.java.cma.model.CMAVisibility;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleTags
extends AbsModule<ServiceContentTags> {
    final Async async = new Async();

    public ModuleTags(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceContentTags createService(Retrofit retrofit) {
        return (ServiceContentTags)retrofit.create(ServiceContentTags.class);
    }

    public CMATag create(String environmentId, String spaceId, String tagId, String name, CMAVisibility visibility) {
        this.assertNotNull(spaceId, "spaceId");
        CMATag tag = new CMATag();
        tag.setName(name);
        tag.setId(tagId);
        tag.setVisibility(visibility);
        return (CMATag)((ServiceContentTags)this.service).create(spaceId, environmentId, tagId, tag).blockingFirst();
    }

    public Integer delete(String spaceId, String environmentId, String tagId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(tagId, "tagId");
        return ((Response)((ServiceContentTags)this.service).delete(spaceId, environmentId, tagId).blockingFirst()).code();
    }

    public CMAArray<CMATag> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId, new HashMap<String, String>());
    }

    public CMAArray<CMATag> fetchAll(String spaceId, String environmentId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
        return (CMAArray)((ServiceContentTags)this.service).fetchAll(spaceId, environmentId, query).blockingFirst();
    }

    public CMATag fetchOne(String tagId) {
        return this.fetchOne(this.spaceId, this.environmentId, tagId);
    }

    public CMATag fetchOne(String spaceId, String environmentId, String tagId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        return (CMATag)((ServiceContentTags)this.service).fetchOne(spaceId, environmentId, tagId).blockingFirst();
    }

    public CMATag update(String name, String tagId) {
        this.assertNotNull(name, "name");
        this.assertNotNull(tagId, "tagId");
        CMATag tag = new CMATag();
        tag.setName(name);
        tag.setId(tagId);
        return (CMATag)((ServiceContentTags)this.service).update(this.spaceId, this.environmentId, tagId, tag).blockingFirst();
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMATag> create(final String spaceId, final String environmentId, final String tagId, final String name, final CMAVisibility visibility, CMACallback<CMATag> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMATag>(){

                @Override
                CMATag method() {
                    return ModuleTags.this.create(spaceId, environmentId, tagId, name, visibility);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final String spaceId, final String environmentId, final String tagId, CMACallback<Integer> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleTags.this.delete(spaceId, environmentId, tagId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMATag>> fetchAll(CMACallback<CMAArray<CMATag>> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMAArray<CMATag>>(){

                @Override
                CMAArray<CMATag> method() {
                    return ModuleTags.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMATag>> fetchAll(final String spaceId, final String environmentId, final Map<String, String> query, CMACallback<CMAArray<CMATag>> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMAArray<CMATag>>(){

                @Override
                CMAArray<CMATag> method() {
                    return ModuleTags.this.fetchAll(spaceId, environmentId, query);
                }
            }, callback);
        }

        public CMACallback<CMATag> fetchOne(final String tagId, CMACallback<CMATag> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMATag>(){

                @Override
                CMATag method() {
                    return ModuleTags.this.fetchOne(tagId);
                }
            }, callback);
        }

        public CMACallback<CMATag> fetchOne(final String spaceId, final String environmentId, final String tagId, CMACallback<CMATag> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMATag>(){

                @Override
                CMATag method() {
                    return ModuleTags.this.fetchOne(spaceId, environmentId, tagId);
                }
            }, callback);
        }

        public CMACallback<CMATag> update(final String name, final String tagId, CMACallback<CMATag> callback) {
            return ModuleTags.this.defer(new RxExtensions.DefFunc<CMATag>(){

                @Override
                CMATag method() {
                    return ModuleTags.this.update(name, tagId);
                }
            }, callback);
        }
    }
}

