/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceUiExtensions;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAUiExtension;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleUiExtensions
extends AbsModule<ServiceUiExtensions> {
    final Async async = new Async();

    public ModuleUiExtensions(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceUiExtensions createService(Retrofit retrofit) {
        return (ServiceUiExtensions)retrofit.create(ServiceUiExtensions.class);
    }

    public CMAUiExtension fetchOne(String extensionId) {
        return this.fetchOne(this.spaceId, this.environmentId, extensionId);
    }

    public CMAUiExtension fetchOne(String spaceId, String environmentId, String extensionId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "spaceId");
        this.assertNotNull(extensionId, "extensionId");
        return (CMAUiExtension)((ServiceUiExtensions)this.service).fetchOne(spaceId, environmentId, extensionId).blockingFirst();
    }

    public CMAArray<CMAUiExtension> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId);
    }

    public CMAArray<CMAUiExtension> fetchAll(Map<String, String> query) {
        return this.fetchAll(this.spaceId, this.environmentId, query);
    }

    public CMAArray<CMAUiExtension> fetchAll(String spaceId, String environmentId) {
        return this.fetchAll(spaceId, environmentId, null);
    }

    public CMAArray<CMAUiExtension> fetchAll(String spaceId, String environmentId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        if (query == null) {
            return (CMAArray)((ServiceUiExtensions)this.service).fetchAll(spaceId, environmentId).blockingFirst();
        }
        return (CMAArray)((ServiceUiExtensions)this.service).fetchAll(spaceId, environmentId, query).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAUiExtension update(CMAUiExtension extension) {
        this.assertNotNull(extension, "extension");
        Integer version = this.getVersionOrThrow(extension, "update");
        String id = this.getResourceIdOrThrow(extension, "extension");
        String spaceId = this.getSpaceIdOrThrow(extension, "extension");
        this.assertNotNull(extension.getEnvironmentId(), "environmentId");
        String environmentId = extension.getEnvironmentId();
        CMASystem system = extension.getSystem();
        extension.setSystem(null);
        try {
            CMAUiExtension cMAUiExtension = (CMAUiExtension)((ServiceUiExtensions)this.service).update(spaceId, environmentId, id, extension, version).blockingFirst();
            return cMAUiExtension;
        }
        finally {
            extension.setSystem(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer delete(CMAUiExtension extension) {
        this.assertNotNull(extension, "extension");
        Integer version = this.getVersionOrThrow(extension, "update");
        String spaceId = this.getSpaceIdOrThrow(extension, "extension");
        this.assertNotNull(extension.getEnvironmentId(), "environmentId");
        String environmentId = extension.getEnvironmentId();
        String extensionId = this.getResourceIdOrThrow(extension, "extension");
        CMASystem system = extension.getSystem();
        extension.setSystem(null);
        try {
            Integer n = ((Response)((ServiceUiExtensions)this.service).delete(spaceId, environmentId, extensionId, version).blockingFirst()).code();
            return n;
        }
        finally {
            extension.setSystem(system);
        }
    }

    public CMAUiExtension create(CMAUiExtension extension) {
        return this.create(this.spaceId, this.environmentId, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAUiExtension create(String spaceId, String environmentId, CMAUiExtension extension) {
        this.assertNotNull(extension, "extension");
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        String id = extension.getId();
        CMASystem system = extension.getSystem();
        extension.setSystem(null);
        try {
            if (id == null) {
                CMAUiExtension cMAUiExtension = (CMAUiExtension)((ServiceUiExtensions)this.service).create(spaceId, environmentId, extension).blockingFirst();
                return cMAUiExtension;
            }
            CMAUiExtension cMAUiExtension = (CMAUiExtension)((ServiceUiExtensions)this.service).create(spaceId, environmentId, id, extension).blockingFirst();
            return cMAUiExtension;
        }
        finally {
            extension.setSystem(system);
        }
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAUiExtension> fetchOne(final String extensionId, CMACallback<CMAUiExtension> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAUiExtension>(){

                @Override
                CMAUiExtension method() {
                    return ModuleUiExtensions.this.fetchOne(extensionId);
                }
            }, callback);
        }

        public CMACallback<CMAUiExtension> fetchOne(final String spaceId, final String environmentId, final String extensionId, CMACallback<CMAUiExtension> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAUiExtension>(){

                @Override
                CMAUiExtension method() {
                    return ModuleUiExtensions.this.fetchOne(spaceId, environmentId, extensionId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAUiExtension>> fetchAll(final String spaceId, final String environmentId, CMACallback<CMAArray<CMAUiExtension>> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAArray<CMAUiExtension>>(){

                @Override
                CMAArray<CMAUiExtension> method() {
                    return ModuleUiExtensions.this.fetchAll(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAUiExtension>> fetchAll(CMACallback<CMAArray<CMAUiExtension>> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAArray<CMAUiExtension>>(){

                @Override
                CMAArray<CMAUiExtension> method() {
                    return ModuleUiExtensions.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAUiExtension>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAUiExtension>> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAArray<CMAUiExtension>>(){

                @Override
                CMAArray<CMAUiExtension> method() {
                    return ModuleUiExtensions.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAUiExtension>> fetchAll(final String spaceId, final String environmentId, final Map<String, String> query, CMACallback<CMAArray<CMAUiExtension>> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAArray<CMAUiExtension>>(){

                @Override
                CMAArray<CMAUiExtension> method() {
                    return ModuleUiExtensions.this.fetchAll(spaceId, environmentId, query);
                }
            }, callback);
        }

        public CMACallback<CMAUiExtension> update(final CMAUiExtension extension, CMACallback<CMAUiExtension> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAUiExtension>(){

                @Override
                CMAUiExtension method() {
                    return ModuleUiExtensions.this.update(extension);
                }
            }, callback);
        }

        public CMACallback<CMAUiExtension> create(final String spaceId, final String environmentId, final CMAUiExtension extension, CMACallback<CMAUiExtension> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAUiExtension>(){

                @Override
                CMAUiExtension method() {
                    return ModuleUiExtensions.this.create(spaceId, environmentId, extension);
                }
            }, callback);
        }

        public CMACallback<CMAUiExtension> create(final CMAUiExtension extension, CMACallback<CMAUiExtension> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<CMAUiExtension>(){

                @Override
                CMAUiExtension method() {
                    return ModuleUiExtensions.this.create(extension);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAUiExtension extension, CMACallback<Integer> callback) {
            return ModuleUiExtensions.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleUiExtensions.this.delete(extension);
                }
            }, callback);
        }
    }
}

