/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.interceptor;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class ContentTypeInterceptor
implements Interceptor {
    public static final String HEADER_NAME = "Content-Type";
    private final String contentType;
    private final MediaType mediaType;

    public ContentTypeInterceptor(String contentType) {
        this.contentType = contentType;
        this.mediaType = MediaType.parse((String)contentType);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder().addHeader(HEADER_NAME, this.contentType);
        if (request.body() != null) {
            this.rewriteBodyWithCustomContentType(request, builder);
        }
        Request contentTypeRequest = builder.build();
        return chain.proceed(contentTypeRequest);
    }

    private void rewriteBodyWithCustomContentType(Request request, Request.Builder builder) throws IOException {
        Buffer sink = new Buffer();
        request.body().writeTo((BufferedSink)sink);
        byte[] content = sink.readByteArray();
        RequestBody body = RequestBody.create((MediaType)this.mediaType, (byte[])content);
        if ("POST".equals(request.method())) {
            builder.post(body);
        } else if ("PUT".equals(request.method())) {
            builder.put(body);
        }
    }
}

