/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.interceptor;

import com.contentful.java.cma.Logger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class LogInterceptor
implements Interceptor {
    private static final double NANOS_PER_SECOND = 1000000.0;
    private final Logger logger;

    public LogInterceptor(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null for interception ...");
        }
        this.logger = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        this.logger.log(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        this.logger.log(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

