/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMAType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CMAEditorInterface
extends CMAResource {
    List<Control> controls;

    public CMAEditorInterface() {
        super(CMAType.EditorInterface);
    }

    public CMAEditorInterface addControl(Control control) {
        if (this.controls == null) {
            this.controls = new ArrayList<Control>();
        }
        this.controls.add(control);
        return this;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    @Override
    public String toString() {
        return "CMAEditorInterface { " + super.toString() + " controls = " + this.getControls() + " }";
    }

    public static class Control {
        private static final String SETTINGS_KEY_HELP_TEXT = "helpText";
        String fieldId;
        String widgetId;
        Map<String, String> settings;

        public String getFieldId() {
            return this.fieldId;
        }

        public Control setFieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public BuildInWidgetId getBuildInWidgetId() {
            for (BuildInWidgetId id : BuildInWidgetId.values()) {
                if (!id.name().toLowerCase().equals(this.widgetId.toLowerCase())) continue;
                return id;
            }
            return null;
        }

        public Control setBuildInWidgetId(BuildInWidgetId buildInWidgetId) {
            this.widgetId = buildInWidgetId.name();
            return this;
        }

        public String getWidgetId() {
            return this.widgetId;
        }

        public Control setWidgetId(String widgetId) {
            this.widgetId = widgetId;
            return this;
        }

        public Control addSetting(String key, String value) {
            if (this.settings == null) {
                this.settings = new LinkedHashMap<String, String>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Control addHelpText(String helpText) {
            if (this.settings == null) {
                this.settings = new LinkedHashMap<String, String>();
            }
            this.settings.put(SETTINGS_KEY_HELP_TEXT, helpText);
            return this;
        }

        public String getHelpText() {
            return this.settings != null ? this.settings.get(SETTINGS_KEY_HELP_TEXT) : null;
        }

        public Map<String, String> getSettings() {
            return this.settings;
        }

        public String toString() {
            return "Control { fieldId = " + this.getFieldId() + ", settings = " + this.getSettings() + ", widgetId = " + this.getWidgetId() + " }";
        }

        public static enum BuildInWidgetId {
            AssetGalleryEditor,
            AssetLinkEditor,
            AssetLinksEditor,
            Boolean,
            Checkbox,
            DatePicker,
            Dropdown,
            EntryCardEditor,
            EntryCardsEditor,
            EntryLinkEditor,
            EntryLinksEditor,
            KalturaEditor,
            KalturaMultiVideoEditor,
            ListInput,
            LocationEditor,
            Markdown,
            MultipleLine,
            NumberEditor,
            ObjectEditor,
            OoyalaEditor,
            OoyalaMultiAssetEditor,
            Radio,
            Rating,
            SingleLine,
            SlugEditor,
            TagEditor,
            UrlEditor;

        }
    }
}

