/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMAEnvironmentStatus;
import com.contentful.java.cma.model.CMALink;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;

public class CMAEnvironment
extends CMAResource {
    String name;

    public CMAEnvironment() {
        super(CMAType.Environment);
    }

    public CMAEnvironment setSystem(CMASystem system) {
        this.system = system;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CMAEnvironment setName(String name) {
        this.name = name;
        return this;
    }

    public CMAEnvironment setId(String id) {
        return (CMAEnvironment)super.setId(id);
    }

    @Override
    public String getEnvironmentId() {
        return this.getId();
    }

    @Override
    public <T extends CMAResource> T setEnvironmentId(String environmentId) {
        return (T)this.setId(environmentId);
    }

    public CMAEnvironment setVersion(Integer version) {
        return (CMAEnvironment)super.setVersion(version);
    }

    public CMAEnvironmentStatus getStatus() {
        CMALink link = this.system.getEnvironmentalStatus();
        if (link == null) {
            return null;
        }
        String id = link.getId().toLowerCase();
        for (CMAEnvironmentStatus status : CMAEnvironmentStatus.values()) {
            String statusName = status.name().toLowerCase();
            if (!statusName.equals(id)) continue;
            return status;
        }
        return null;
    }

    @Override
    public String toString() {
        return "CMAEnvironment { " + super.toString() + " name = " + this.getName() + " }";
    }
}

