/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceEditorInterfaces;
import com.contentful.java.cma.model.CMAEditorInterface;
import com.contentful.java.cma.model.CMASystem;
import java.util.concurrent.Executor;
import retrofit2.Retrofit;

public class ModuleEditorInterfaces
extends AbsModule<ServiceEditorInterfaces> {
    final Async async = new Async();

    public ModuleEditorInterfaces(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceEditorInterfaces createService(Retrofit retrofit) {
        return (ServiceEditorInterfaces)retrofit.create(ServiceEditorInterfaces.class);
    }

    public CMAEditorInterface fetchOne(String contentTypeId) {
        return this.fetchOne(this.spaceId, this.environmentId, contentTypeId);
    }

    public CMAEditorInterface fetchOne(String spaceId, String environmentId, String contentTypeId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(contentTypeId, "contentTypeId");
        return (CMAEditorInterface)((ServiceEditorInterfaces)this.service).fetchOne(spaceId, environmentId, contentTypeId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEditorInterface update(CMAEditorInterface editor) {
        String spaceId = this.getSpaceIdOrThrow(editor, "editor");
        if (editor.getSystem().getContentType() == null) {
            throw new IllegalArgumentException("ContentType of editor interface may not be null!");
        }
        if (editor.getSystem().getContentType().getId() == null) {
            throw new IllegalArgumentException("Id of ContentType of editor interface may not be null!");
        }
        String contentTypeId = editor.getSystem().getContentType().getId();
        String environmentId = editor.getEnvironmentId();
        Integer version = this.getVersionOrThrow(editor, "update");
        CMASystem old = editor.getSystem();
        editor.setSystem(null);
        try {
            CMAEditorInterface cMAEditorInterface = (CMAEditorInterface)((ServiceEditorInterfaces)this.service).update(spaceId, environmentId, contentTypeId, editor, version).blockingFirst();
            return cMAEditorInterface;
        }
        finally {
            editor.setSystem(old);
        }
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAEditorInterface> fetchOne(final String contentTypeId, CMACallback<CMAEditorInterface> callback) {
            return ModuleEditorInterfaces.this.defer(new RxExtensions.DefFunc<CMAEditorInterface>(){

                @Override
                CMAEditorInterface method() {
                    return ModuleEditorInterfaces.this.fetchOne(contentTypeId);
                }
            }, callback);
        }

        public CMACallback<CMAEditorInterface> fetchOne(final String spaceId, final String environmentId, final String contentTypeId, CMACallback<CMAEditorInterface> callback) {
            return ModuleEditorInterfaces.this.defer(new RxExtensions.DefFunc<CMAEditorInterface>(){

                @Override
                CMAEditorInterface method() {
                    return ModuleEditorInterfaces.this.fetchOne(spaceId, environmentId, contentTypeId);
                }
            }, callback);
        }

        public CMACallback<CMAEditorInterface> update(final CMAEditorInterface editor, CMACallback<CMAEditorInterface> callback) {
            return ModuleEditorInterfaces.this.defer(new RxExtensions.DefFunc<CMAEditorInterface>(){

                @Override
                CMAEditorInterface method() {
                    return ModuleEditorInterfaces.this.update(editor);
                }
            }, callback);
        }
    }
}

