/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.DefaultQueryParameter;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceEntries;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAEntry;
import com.contentful.java.cma.model.CMASnapshot;
import com.contentful.java.cma.model.CMASystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleEntries
extends AbsModule<ServiceEntries> {
    final Async async = new Async();

    public ModuleEntries(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceEntries createService(Retrofit retrofit) {
        return (ServiceEntries)retrofit.create(ServiceEntries.class);
    }

    public CMAEntry archive(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        return (CMAEntry)((ServiceEntries)this.service).archive(spaceId, environmentId, entryId).blockingFirst();
    }

    public CMAEntry create(String contentTypeId, CMAEntry entry) {
        return this.create(this.spaceId, this.environmentId, contentTypeId, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEntry create(String spaceId, String environmentId, String contentTypeId, CMAEntry entry) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(entry, "entry");
        String entryId = entry.getSystem().getId();
        CMASystem sys = entry.getSystem();
        entry.setSystem(null);
        try {
            if (entryId == null) {
                CMAEntry cMAEntry = (CMAEntry)((ServiceEntries)this.service).create(spaceId, environmentId, contentTypeId, entry).blockingFirst();
                return cMAEntry;
            }
            CMAEntry cMAEntry = (CMAEntry)((ServiceEntries)this.service).create(spaceId, environmentId, contentTypeId, entryId, entry).blockingFirst();
            return cMAEntry;
        }
        finally {
            entry.setSystem(sys);
        }
    }

    public Integer delete(CMAEntry entry) {
        this.assertNotNull(entry.getSpaceId(), "spaceId");
        this.assertNotNull(entry.getEnvironmentId(), "environmentId");
        this.assertNotNull(entry.getId(), "entryId");
        return ((Response)((ServiceEntries)this.service).delete(entry.getSpaceId(), entry.getEnvironmentId(), entry.getId()).blockingFirst()).code();
    }

    public CMAArray<CMAEntry> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId);
    }

    public CMAArray<CMAEntry> fetchAll(Map<String, String> query) {
        return this.fetchAll(this.spaceId, this.environmentId, query);
    }

    public CMAArray<CMAEntry> fetchAll(String spaceId, String environmentId) {
        return this.fetchAll(spaceId, environmentId, new HashMap<String, String>());
    }

    public CMAArray<CMAEntry> fetchAll(String spaceId, String environmentId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        Map<String, String> enhancedQuery = DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
        return (CMAArray)((ServiceEntries)this.service).fetchAll(spaceId, environmentId, enhancedQuery).blockingFirst();
    }

    public CMAEntry fetchOne(String entryId) {
        return this.fetchOne(this.spaceId, this.environmentId, entryId);
    }

    public CMAEntry fetchOne(String spaceId, String environmentId, String entryId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(entryId, "entryId");
        return (CMAEntry)((ServiceEntries)this.service).fetchOne(spaceId, environmentId, entryId).blockingFirst();
    }

    public CMAEntry publish(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        return (CMAEntry)((ServiceEntries)this.service).publish(entry.getSystem().getVersion(), spaceId, environmentId, entryId).blockingFirst();
    }

    public CMAEntry unArchive(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        return (CMAEntry)((ServiceEntries)this.service).unArchive(spaceId, environmentId, entryId).blockingFirst();
    }

    public CMAEntry unPublish(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        return (CMAEntry)((ServiceEntries)this.service).unPublish(spaceId, environmentId, entryId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAEntry update(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        Integer version = this.getVersionOrThrow(entry, "update");
        CMASystem system = entry.getSystem();
        entry.setSystem(null);
        try {
            CMAEntry cMAEntry = (CMAEntry)((ServiceEntries)this.service).update(version, spaceId, environmentId, entryId, entry).blockingFirst();
            return cMAEntry;
        }
        finally {
            entry.setSystem(system);
        }
    }

    public CMAArray<CMASnapshot> fetchAllSnapshots(CMAEntry entry) {
        this.assertNotNull(entry, "entry");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        return (CMAArray)((ServiceEntries)this.service).fetchAllSnapshots(spaceId, environmentId, entryId).blockingFirst();
    }

    public CMASnapshot fetchOneSnapshot(CMAEntry entry, String snapshotId) {
        this.assertNotNull(entry, "entry");
        this.assertNotNull(snapshotId, "snapshotId");
        String entryId = this.getResourceIdOrThrow(entry, "entry");
        String spaceId = this.getSpaceIdOrThrow(entry, "entry");
        String environmentId = entry.getEnvironmentId();
        return (CMASnapshot)((ServiceEntries)this.service).fetchOneSnapshot(spaceId, environmentId, entryId, snapshotId).blockingFirst();
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAEntry> archive(final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.archive(entry);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> create(final String contentTypeId, final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.create(contentTypeId, entry);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> create(final String spaceId, final String environmentId, final String contentTypeId, final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.create(spaceId, environmentId, contentTypeId, entry);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAEntry entry, CMACallback<Integer> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleEntries.this.delete(entry);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEntry>> fetchAll(CMACallback<CMAArray<CMAEntry>> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEntry>>(){

                @Override
                CMAArray<CMAEntry> method() {
                    return ModuleEntries.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEntry>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAEntry>> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEntry>>(){

                @Override
                CMAArray<CMAEntry> method() {
                    return ModuleEntries.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEntry>> fetchAll(final String spaceId, final String environmentId, CMACallback<CMAArray<CMAEntry>> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEntry>>(){

                @Override
                CMAArray<CMAEntry> method() {
                    return ModuleEntries.this.fetchAll(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAEntry>> fetchAll(final String spaceId, final String environmentId, final Map<String, String> query, CMACallback<CMAArray<CMAEntry>> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAArray<CMAEntry>>(){

                @Override
                CMAArray<CMAEntry> method() {
                    return ModuleEntries.this.fetchAll(spaceId, environmentId, query);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> fetchOne(final String entryId, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.fetchOne(entryId);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> fetchOne(final String spaceId, final String environmentId, final String entryId, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.fetchOne(spaceId, environmentId, entryId);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> publish(final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.publish(entry);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> unArchive(final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.unArchive(entry);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> unPublish(final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.unPublish(entry);
                }
            }, callback);
        }

        public CMACallback<CMAEntry> update(final CMAEntry entry, CMACallback<CMAEntry> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAEntry>(){

                @Override
                CMAEntry method() {
                    return ModuleEntries.this.update(entry);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASnapshot>> fetchAllSnapshots(final CMAEntry entry, CMACallback<CMAArray<CMASnapshot>> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMAArray<CMASnapshot>>(){

                @Override
                CMAArray<CMASnapshot> method() {
                    return ModuleEntries.this.fetchAllSnapshots(entry);
                }
            }, callback);
        }

        public CMACallback<CMASnapshot> fetchOneSnapshot(final CMAEntry entry, final String snapshotId, CMACallback<CMASnapshot> callback) {
            return ModuleEntries.this.defer(new RxExtensions.DefFunc<CMASnapshot>(){

                @Override
                CMASnapshot method() {
                    return ModuleEntries.this.fetchOneSnapshot(entry, snapshotId);
                }
            }, callback);
        }
    }
}

