/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceLocales;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMALocale;
import com.contentful.java.cma.model.CMASystem;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleLocales
extends AbsModule<ServiceLocales> {
    private final Async async = new Async();

    public ModuleLocales(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceLocales createService(Retrofit retrofit) {
        return (ServiceLocales)retrofit.create(ServiceLocales.class);
    }

    public Async async() {
        return this.async;
    }

    public CMAArray<CMALocale> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId);
    }

    public CMAArray<CMALocale> fetchAll(String spaceId, String environmentId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        return (CMAArray)((ServiceLocales)this.service).fetchAll(spaceId, environmentId).blockingFirst();
    }

    public CMALocale fetchOne(String localeId) {
        return this.fetchOne(this.spaceId, this.environmentId, localeId);
    }

    public CMALocale fetchOne(String spaceId, String environmentId, String localeId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(localeId, "localeId");
        return (CMALocale)((ServiceLocales)this.service).fetchOne(spaceId, environmentId, localeId).blockingFirst();
    }

    public CMALocale create(CMALocale locale) {
        return this.create(this.spaceId, this.environmentId, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMALocale create(String spaceId, String environmentId, CMALocale locale) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(locale, "locale");
        CMASystem sys = locale.getSystem();
        locale.setSystem(null);
        try {
            CMALocale cMALocale = (CMALocale)((ServiceLocales)this.service).create(spaceId, environmentId, locale).blockingFirst();
            return cMALocale;
        }
        finally {
            locale.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMALocale update(CMALocale locale) {
        this.assertNotNull(locale, "locale");
        String id = this.getResourceIdOrThrow(locale, "locale");
        String spaceId = this.getSpaceIdOrThrow(locale, "locale");
        String environmentId = locale.getEnvironmentId();
        Integer version = this.getVersionOrThrow(locale, "update");
        CMASystem sys = locale.getSystem();
        locale.setSystem(null);
        try {
            CMALocale cMALocale = (CMALocale)((ServiceLocales)this.service).update(spaceId, environmentId, id, locale, version).blockingFirst();
            return cMALocale;
        }
        finally {
            locale.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(CMALocale locale) {
        String id = this.getResourceIdOrThrow(locale, "locale");
        String spaceId = this.getSpaceIdOrThrow(locale, "locale");
        String environmentId = locale.getEnvironmentId();
        CMASystem sys = locale.getSystem();
        locale.setSystem(null);
        try {
            Response response = (Response)((ServiceLocales)this.service).delete(spaceId, environmentId, id).blockingFirst();
            int n = response.code();
            return n;
        }
        finally {
            locale.setSystem(sys);
        }
    }

    public class Async {
        public CMACallback<CMAArray<CMALocale>> fetchAll(CMACallback<CMAArray<CMALocale>> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMAArray<CMALocale>>(){

                @Override
                CMAArray<CMALocale> method() {
                    return ModuleLocales.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMALocale>> fetchAll(final String spaceId, final String environmentId, CMACallback<CMAArray<CMALocale>> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMAArray<CMALocale>>(){

                @Override
                CMAArray<CMALocale> method() {
                    return ModuleLocales.this.fetchAll(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMALocale> fetchOne(final String localeId, CMACallback<CMALocale> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMALocale>(){

                @Override
                CMALocale method() {
                    return ModuleLocales.this.fetchOne(localeId);
                }
            }, callback);
        }

        public CMACallback<CMALocale> fetchOne(final String spaceId, final String environmentId, final String localeId, CMACallback<CMALocale> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMALocale>(){

                @Override
                CMALocale method() {
                    return ModuleLocales.this.fetchOne(spaceId, environmentId, localeId);
                }
            }, callback);
        }

        public CMACallback<CMALocale> create(final CMALocale locale, CMACallback<CMALocale> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMALocale>(){

                @Override
                CMALocale method() {
                    return ModuleLocales.this.create(locale);
                }
            }, callback);
        }

        public CMACallback<CMALocale> create(final String spaceId, final String environmentId, final CMALocale locale, CMACallback<CMALocale> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMALocale>(){

                @Override
                CMALocale method() {
                    return ModuleLocales.this.create(spaceId, environmentId, locale);
                }
            }, callback);
        }

        public CMACallback<CMALocale> update(final CMALocale locale, CMACallback<CMALocale> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<CMALocale>(){

                @Override
                CMALocale method() {
                    return ModuleLocales.this.update(locale);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMALocale locale, CMACallback<Integer> callback) {
            return ModuleLocales.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleLocales.this.delete(locale);
                }
            }, callback);
        }
    }
}

