/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceRoles;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMARole;
import com.contentful.java.cma.model.CMASystem;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleRoles
extends AbsModule<ServiceRoles> {
    private final Async async = new Async();

    public ModuleRoles(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceRoles createService(Retrofit retrofit) {
        return (ServiceRoles)retrofit.create(ServiceRoles.class);
    }

    public Async async() {
        return this.async;
    }

    public CMAArray<CMARole> fetchAll() {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId);
    }

    public CMAArray<CMARole> fetchAll(String spaceId) {
        this.assertNotNull(spaceId, "spaceId");
        return (CMAArray)((ServiceRoles)this.service).fetchAll(spaceId).blockingFirst();
    }

    public CMAArray<CMARole> fetchAll(Map<String, String> query) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId, query);
    }

    public CMAArray<CMARole> fetchAll(String spaceId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        if (query == null) {
            return (CMAArray)((ServiceRoles)this.service).fetchAll(spaceId).blockingFirst();
        }
        return (CMAArray)((ServiceRoles)this.service).fetchAll(spaceId, query).blockingFirst();
    }

    public CMARole fetchOne(String roleId) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchOne(this.spaceId, roleId);
    }

    public CMARole fetchOne(String spaceId, String roleId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(roleId, "roleId");
        return (CMARole)((ServiceRoles)this.service).fetchOne(spaceId, roleId).blockingFirst();
    }

    public CMARole create(CMARole role) {
        this.throwIfEnvironmentIdIsSet();
        return this.create(this.spaceId, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMARole create(String spaceId, CMARole role) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(role, "role");
        CMASystem sys = role.getSystem();
        role.setSystem(null);
        try {
            CMARole cMARole = (CMARole)((ServiceRoles)this.service).create(spaceId, role).blockingFirst();
            return cMARole;
        }
        finally {
            role.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMARole update(CMARole role) {
        this.assertNotNull(role, "role");
        String id = this.getResourceIdOrThrow(role, "role");
        String spaceId = this.getSpaceIdOrThrow(role, "role");
        Integer version = this.getVersionOrThrow(role, "update");
        CMASystem sys = role.getSystem();
        role.setSystem(null);
        try {
            CMARole cMARole = (CMARole)((ServiceRoles)this.service).update(spaceId, id, role, version).blockingFirst();
            return cMARole;
        }
        finally {
            role.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(CMARole role) {
        String id = this.getResourceIdOrThrow(role, "role");
        String spaceId = this.getSpaceIdOrThrow(role, "role");
        CMASystem sys = role.getSystem();
        role.setSystem(null);
        try {
            Response response = (Response)((ServiceRoles)this.service).delete(spaceId, id).blockingFirst();
            int n = response.code();
            return n;
        }
        finally {
            role.setSystem(sys);
        }
    }

    public class Async {
        public CMACallback<CMAArray<CMARole>> fetchAll(CMACallback<CMAArray<CMARole>> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMAArray<CMARole>>(){

                @Override
                CMAArray<CMARole> method() {
                    return ModuleRoles.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMARole>> fetchAll(final String spaceId, CMACallback<CMAArray<CMARole>> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMAArray<CMARole>>(){

                @Override
                CMAArray<CMARole> method() {
                    return ModuleRoles.this.fetchAll(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMARole>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMARole>> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMAArray<CMARole>>(){

                @Override
                CMAArray<CMARole> method() {
                    return ModuleRoles.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMARole>> fetchAll(final String spaceId, final Map<String, String> query, CMACallback<CMAArray<CMARole>> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMAArray<CMARole>>(){

                @Override
                CMAArray<CMARole> method() {
                    return ModuleRoles.this.fetchAll(spaceId, query);
                }
            }, callback);
        }

        public CMACallback<CMARole> fetchOne(final String spaceId, final String roleId, CMACallback<CMARole> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMARole>(){

                @Override
                CMARole method() {
                    return ModuleRoles.this.fetchOne(spaceId, roleId);
                }
            }, callback);
        }

        public CMACallback<CMARole> fetchOne(final String roleId, CMACallback<CMARole> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMARole>(){

                @Override
                CMARole method() {
                    return ModuleRoles.this.fetchOne(roleId);
                }
            }, callback);
        }

        public CMACallback<CMARole> create(final String spaceId, final CMARole role, CMACallback<CMARole> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMARole>(){

                @Override
                CMARole method() {
                    return ModuleRoles.this.create(spaceId, role);
                }
            }, callback);
        }

        public CMACallback<CMARole> create(final CMARole role, CMACallback<CMARole> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMARole>(){

                @Override
                CMARole method() {
                    return ModuleRoles.this.create(role);
                }
            }, callback);
        }

        public CMACallback<CMARole> update(final CMARole role, CMACallback<CMARole> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<CMARole>(){

                @Override
                CMARole method() {
                    return ModuleRoles.this.update(role);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMARole role, CMACallback<Integer> callback) {
            return ModuleRoles.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleRoles.this.delete(role);
                }
            }, callback);
        }
    }
}

