/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceUploads;
import com.contentful.java.cma.model.CMAUpload;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleUploads
extends AbsModule<ServiceUploads> {
    final Async async = new Async();

    public ModuleUploads(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    static byte[] readAllBytes(InputStream stream) throws IOException {
        int bytesRead = 0;
        byte[] currentChunk = new byte[255];
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        while ((bytesRead = stream.read(currentChunk)) != -1) {
            chunks.add(Arrays.copyOf(currentChunk, bytesRead));
        }
        if (chunks.size() <= 0) {
            throw new IOException("Stream did not contain any data. Please provide data to upload.");
        }
        int size = 0;
        for (byte[] chunk : chunks) {
            size += chunk.length;
        }
        byte[] content = new byte[size];
        int position = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, content, position, chunk.length);
            position += chunk.length;
        }
        return content;
    }

    @Override
    protected ServiceUploads createService(Retrofit retrofit) {
        return (ServiceUploads)retrofit.create(ServiceUploads.class);
    }

    public CMAUpload create(InputStream stream) throws IOException {
        this.throwIfEnvironmentIdIsSet();
        return this.create(this.spaceId, stream);
    }

    public CMAUpload create(String spaceId, InputStream stream) throws IOException {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(stream, "stream");
        byte[] content = ModuleUploads.readAllBytes(stream);
        RequestBody payload = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])content);
        return (CMAUpload)((ServiceUploads)this.service).create(spaceId, payload).blockingFirst();
    }

    public CMAUpload fetchOne(String uploadId) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchOne(this.spaceId, uploadId);
    }

    public CMAUpload fetchOne(String spaceId, String uploadId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(uploadId, "uploadId");
        return (CMAUpload)((ServiceUploads)this.service).fetchOne(spaceId, uploadId).blockingFirst();
    }

    public int delete(CMAUpload upload) {
        String uploadId = this.getResourceIdOrThrow(upload, "upload");
        String spaceId = this.getSpaceIdOrThrow(upload, "upload");
        Response response = (Response)((ServiceUploads)this.service).delete(spaceId, uploadId).blockingFirst();
        return response.code();
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAUpload> create(final InputStream stream, CMACallback<CMAUpload> callback) {
            return ModuleUploads.this.defer(new RxExtensions.DefFunc<CMAUpload>(){

                @Override
                CMAUpload method() {
                    try {
                        return ModuleUploads.this.create(stream);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("IO exception while creating asset.", e);
                    }
                }
            }, callback);
        }

        public CMACallback<CMAUpload> create(final String spaceId, final InputStream stream, CMACallback<CMAUpload> callback) {
            return ModuleUploads.this.defer(new RxExtensions.DefFunc<CMAUpload>(){

                @Override
                CMAUpload method() {
                    try {
                        return ModuleUploads.this.create(spaceId, stream);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("IO exception while creating asset.", e);
                    }
                }
            }, callback);
        }

        public CMACallback<CMAUpload> fetchOne(final String uploadId, CMACallback<CMAUpload> callback) {
            return ModuleUploads.this.defer(new RxExtensions.DefFunc<CMAUpload>(){

                @Override
                CMAUpload method() {
                    return ModuleUploads.this.fetchOne(uploadId);
                }
            }, callback);
        }

        public CMACallback<CMAUpload> fetchOne(final String spaceId, final String uploadId, CMACallback<CMAUpload> callback) {
            return ModuleUploads.this.defer(new RxExtensions.DefFunc<CMAUpload>(){

                @Override
                CMAUpload method() {
                    return ModuleUploads.this.fetchOne(spaceId, uploadId);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAUpload upload, CMACallback<Integer> callback) {
            return ModuleUploads.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleUploads.this.delete(upload);
                }
            }, callback);
        }
    }
}

