/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import java.util.List;
import java.util.Map;

public class RateLimits {
    private int hourLimit;
    private int hourRemaining;
    private int reset;
    private int secondLimit;
    private int secondRemaining;

    public int getHourLimit() {
        return this.hourLimit;
    }

    public int getHourRemaining() {
        return this.hourRemaining;
    }

    public int getReset() {
        return this.reset;
    }

    public int getSecondLimit() {
        return this.secondLimit;
    }

    public int getSecondRemaining() {
        return this.secondRemaining;
    }

    static class Builder {
        RateLimits limits = new RateLimits();

        public Builder setHourLimit(int hourLimit) {
            this.limits.hourLimit = hourLimit;
            return this;
        }

        public Builder setHourRemaining(int hourRemaining) {
            this.limits.hourRemaining = hourRemaining;
            return this;
        }

        public Builder setReset(int reset) {
            this.limits.reset = reset;
            return this;
        }

        public Builder setSecondLimit(int secondLimit) {
            this.limits.secondLimit = secondLimit;
            return this;
        }

        public Builder setSecondRemaining(int secondRemaining) {
            this.limits.secondRemaining = secondRemaining;
            return this;
        }

        public RateLimits build() {
            return this.limits;
        }
    }

    public static class DefaultParser
    implements Parser {
        @Override
        public RateLimits parse(Map<String, List<String>> headers) {
            return new Builder().setHourLimit(this.findLimit(headers, "X-Contentful-RateLimit-Hour-Limit")).setHourRemaining(this.findLimit(headers, "X-Contentful-RateLimit-Hour-Remaining")).setSecondLimit(this.findLimit(headers, "X-Contentful-RateLimit-Second-Limit")).setSecondRemaining(this.findLimit(headers, "X-Contentful-RateLimit-Second-Remaining")).setReset(this.findLimit(headers, "X-Contentful-RateLimit-Reset")).build();
        }

        private int findLimit(Map<String, List<String>> headers, String key) {
            if (headers.containsKey(key) && headers.get(key) != null) {
                try {
                    return Integer.parseInt(headers.get(key).get(0));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            return 0;
        }
    }

    public static interface Parser {
        public static final String HEADER_HOUR_LIMIT = "X-Contentful-RateLimit-Hour-Limit";
        public static final String HEADER_HOUR_REMAINING = "X-Contentful-RateLimit-Hour-Remaining";
        public static final String HEADER_SECOND_LIMIT = "X-Contentful-RateLimit-Second-Limit";
        public static final String HEADER_SECOND_REMAINING = "X-Contentful-RateLimit-Second-Remaining";
        public static final String HEADER_RESET = "X-Contentful-RateLimit-Reset";

        public RateLimits parse(Map<String, List<String>> var1);
    }
}

