/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda.rich;

import com.contentful.java.cda.ArrayResource;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAField;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.rich.CDARichBlock;
import com.contentful.java.cda.rich.CDARichDocument;
import com.contentful.java.cda.rich.CDARichEmbeddedBlock;
import com.contentful.java.cda.rich.CDARichEmbeddedInline;
import com.contentful.java.cda.rich.CDARichHeading;
import com.contentful.java.cda.rich.CDARichHorizontalRule;
import com.contentful.java.cda.rich.CDARichHyperLink;
import com.contentful.java.cda.rich.CDARichListItem;
import com.contentful.java.cda.rich.CDARichMark;
import com.contentful.java.cda.rich.CDARichNode;
import com.contentful.java.cda.rich.CDARichOrderedList;
import com.contentful.java.cda.rich.CDARichParagraph;
import com.contentful.java.cda.rich.CDARichQuote;
import com.contentful.java.cda.rich.CDARichTable;
import com.contentful.java.cda.rich.CDARichTableCell;
import com.contentful.java.cda.rich.CDARichTableHeaderCell;
import com.contentful.java.cda.rich.CDARichTableRow;
import com.contentful.java.cda.rich.CDARichText;
import com.contentful.java.cda.rich.CDARichUnorderedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RichTextFactory {
    private static final int HEADING_LEVEL_1 = 1;
    private static final int HEADING_LEVEL_2 = 2;
    private static final int HEADING_LEVEL_3 = 3;
    private static final int HEADING_LEVEL_4 = 4;
    private static final int HEADING_LEVEL_5 = 5;
    private static final int HEADING_LEVEL_6 = 6;
    public static final Map<String, Resolver> RESOLVER_MAP = new HashMap<String, Resolver>();

    public static void resolveRichTextField(ArrayResource array, CDAClient client) {
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.ensureContentType(entry, client);
            for (CDAField field : entry.contentType().fields()) {
                if (!"RichText".equals(field.type())) continue;
                RichTextFactory.resolveRichDocument(entry, field);
                RichTextFactory.resolveRichLink(array, entry, field);
            }
        }
    }

    private static void resolveRichDocument(CDAEntry entry, CDAField field) {
        Map rawValue = (Map)entry.rawFields().get(field.id());
        if (rawValue == null) {
            return;
        }
        for (String locale : rawValue.keySet()) {
            Object raw = rawValue.get(locale);
            if (raw == null || raw instanceof CDARichNode) continue;
            Map map = (Map)rawValue.get(locale);
            entry.setField(locale, field.id(), RESOLVER_MAP.get("document").resolve(map));
        }
    }

    static List<CDARichMark> resolveMarks(List<Map<String, Object>> rawMarks) {
        ArrayList<CDARichMark> marks = new ArrayList<CDARichMark>(rawMarks.size());
        for (Map<String, Object> rawMark : rawMarks) {
            String type = (String)rawMark.get("type");
            if ("bold".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkBold());
                continue;
            }
            if ("italic".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkItalic());
                continue;
            }
            if ("underline".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkUnderline());
                continue;
            }
            if ("code".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkCode());
                continue;
            }
            if ("subscript".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkSubscript());
                continue;
            }
            if ("superscript".equals(type)) {
                marks.add(new CDARichMark.CDARichMarkSuperscript());
                continue;
            }
            marks.add(new CDARichMark.CDARichMarkCustom(type));
        }
        return marks;
    }

    static CDARichNode resolveRichNode(Map<String, Object> rawNode) {
        String type = (String)rawNode.get("nodeType");
        if (RESOLVER_MAP.containsKey(type)) {
            return RESOLVER_MAP.get(type).resolve(rawNode);
        }
        return null;
    }

    private static void resolveRichLink(ArrayResource array, CDAEntry entry, CDAField field) {
        Map rawValue = (Map)entry.rawFields().get(field.id());
        if (rawValue == null) {
            return;
        }
        for (String locale : rawValue.keySet()) {
            CDARichDocument document = (CDARichDocument)entry.getField(locale, field.id());
            for (CDARichNode node : document.getContent()) {
                RichTextFactory.resolveOneLink(array, field, locale, node);
            }
        }
    }

    private static void resolveOneLink(ArrayResource array, CDAField field, String locale, CDARichNode node) {
        block33: {
            block29: {
                Object target;
                Map data;
                block30: {
                    block31: {
                        String id;
                        String linkType;
                        block32: {
                            if (!(node instanceof CDARichHyperLink) || !(((CDARichHyperLink)node).data instanceof Map)) break block29;
                            CDARichHyperLink link = (CDARichHyperLink)node;
                            data = (Map)link.data;
                            target = data.get("target");
                            if (!(target instanceof Map)) break block30;
                            if (!RichTextFactory.isLink(target)) break block31;
                            Map map = (Map)target;
                            Map sys = (Map)map.get("sys");
                            linkType = (String)sys.get("linkType");
                            id = (String)sys.get("id");
                            if (!"Asset".equals(linkType)) break block32;
                            link.data = array.assets().get(id);
                            break block33;
                        }
                        if (!"Entry".equals(linkType)) break block33;
                        link.data = array.entries().get(id);
                        break block33;
                    }
                    throw new IllegalStateException("Could not parse content of data field '" + field.id() + "' for locale '" + locale + "' at node '" + node + "'. Please check your content type model.");
                }
                if (target != null || !data.containsKey("uri")) break block33;
                link.data = data.get("uri");
                break block33;
            }
            if (node instanceof CDARichParagraph) {
                for (CDARichNode child : ((CDARichParagraph)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichTableHeaderCell) {
                for (CDARichNode child : ((CDARichTableHeaderCell)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichTableCell) {
                for (CDARichNode child : ((CDARichTableCell)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichTableRow) {
                for (CDARichNode child : ((CDARichTableRow)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichTable) {
                for (CDARichNode child : ((CDARichTable)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichUnorderedList) {
                for (CDARichNode child : ((CDARichUnorderedList)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichQuote) {
                for (CDARichNode child : ((CDARichQuote)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichOrderedList) {
                for (CDARichNode child : ((CDARichOrderedList)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichListItem) {
                for (CDARichNode child : ((CDARichListItem)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            } else if (node instanceof CDARichHeading) {
                for (CDARichNode child : ((CDARichHeading)node).getContent()) {
                    RichTextFactory.resolveOneLink(array, field, locale, child);
                }
            }
        }
    }

    private static boolean isLink(Object data) {
        try {
            Map map = (Map)data;
            Map sys = (Map)map.get("sys");
            String type = (String)sys.get("type");
            String linkType = (String)sys.get("linkType");
            String id = (String)sys.get("id");
            if ("Link".equals(type) && ("Entry".equals(linkType) || "Asset".equals(linkType) && id != null)) {
                return true;
            }
        }
        catch (ClassCastException cast) {
            return false;
        }
        return false;
    }

    static {
        RESOLVER_MAP.put("text", raw -> new CDARichText((CharSequence)raw.get("value"), RichTextFactory.resolveMarks((List)raw.get("marks"))));
        RESOLVER_MAP.put("hr", raw -> new CDARichHorizontalRule());
        RESOLVER_MAP.put("blockquote", new BlockResolver<CDARichQuote>(CDARichQuote::new));
        RESOLVER_MAP.put("paragraph", new BlockResolver<CDARichParagraph>(CDARichParagraph::new));
        RESOLVER_MAP.put("document", new BlockResolver<CDARichDocument>(CDARichDocument::new));
        RESOLVER_MAP.put("list-item", new BlockResolver<CDARichListItem>(CDARichListItem::new));
        RESOLVER_MAP.put("ordered-list", new BlockResolver<CDARichOrderedList>(CDARichOrderedList::new));
        RESOLVER_MAP.put("unordered-list", new BlockResolver<CDARichUnorderedList>(CDARichUnorderedList::new));
        RESOLVER_MAP.put("table", new BlockResolver<CDARichTable>(CDARichTable::new));
        RESOLVER_MAP.put("table-row", new BlockResolver<CDARichTableRow>(CDARichTableRow::new));
        RESOLVER_MAP.put("table-header-cell", new BlockResolver<CDARichTableHeaderCell>(CDARichTableHeaderCell::new));
        RESOLVER_MAP.put("table-cell", new BlockResolver<CDARichTableCell>(CDARichTableCell::new));
        RESOLVER_MAP.put("hyperlink", new BlockAndDataResolver<CDARichHyperLink>(CDARichHyperLink::new, "data"));
        RESOLVER_MAP.put("entry-hyperlink", new BlockAndDataResolver<CDARichHyperLink>(CDARichHyperLink::new, "data"));
        RESOLVER_MAP.put("asset-hyperlink", new BlockAndDataResolver<CDARichHyperLink>(CDARichHyperLink::new, "data"));
        RESOLVER_MAP.put("embedded-entry-block", new BlockAndDataResolver<CDARichEmbeddedBlock>(CDARichEmbeddedBlock::new, "data"));
        RESOLVER_MAP.put("embedded-entry-inline", new BlockAndDataResolver<CDARichEmbeddedInline>(CDARichEmbeddedInline::new, "data"));
        RESOLVER_MAP.put("embedded-asset-block", new BlockAndDataResolver<CDARichEmbeddedBlock>(CDARichEmbeddedBlock::new, "data"));
        RESOLVER_MAP.put("heading-1", new HeadingResolver(1));
        RESOLVER_MAP.put("heading-2", new HeadingResolver(2));
        RESOLVER_MAP.put("heading-3", new HeadingResolver(3));
        RESOLVER_MAP.put("heading-4", new HeadingResolver(4));
        RESOLVER_MAP.put("heading-5", new HeadingResolver(5));
        RESOLVER_MAP.put("heading-6", new HeadingResolver(6));
    }

    private static class BlockAndDataResolver<T extends CDARichBlock>
    extends BlockResolver<T> {
        final SupplierWithData<T> supplier;
        final String dataFieldKey;

        BlockAndDataResolver(SupplierWithData<T> supplier, String dataFieldKey) {
            super(null);
            this.supplier = supplier;
            this.dataFieldKey = dataFieldKey;
        }

        @Override
        T getCDAType(Map<String, Object> raw) {
            return (T)((CDARichBlock)this.supplier.get(raw.get(this.dataFieldKey)));
        }
    }

    private static class HeadingResolver
    extends BlockResolver<CDARichHeading> {
        final int level;

        HeadingResolver(final int level) {
            super(new Supplier<CDARichHeading>(){

                @Override
                public CDARichHeading get() {
                    return new CDARichHeading(level);
                }
            });
            this.level = level;
        }
    }

    public static class BlockResolver<T extends CDARichBlock>
    implements Resolver {
        final Supplier<T> supplier;

        public BlockResolver(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public CDARichNode resolve(Map<String, Object> raw) {
            T resolved = this.getCDAType(raw);
            List contents = (List)raw.get("content");
            for (Map rawNode : contents) {
                CDARichNode resolvedNode = RichTextFactory.resolveRichNode(rawNode);
                if (resolvedNode == null) continue;
                ((CDARichBlock)resolved).content.add(resolvedNode);
            }
            return resolved;
        }

        T getCDAType(Map<String, Object> raw) {
            return (T)((CDARichBlock)this.supplier.get());
        }
    }

    private static interface SupplierWithData<T> {
        public T get(Object var1);
    }

    public static interface Supplier<T> {
        public T get();
    }

    private static interface Resolver {
        public CDARichNode resolve(Map<String, Object> var1);
    }
}

