/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDALocale;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAService;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.FetchQuery;
import com.contentful.java.cda.Logger;
import com.contentful.java.cda.ObserveQuery;
import com.contentful.java.cda.Platform;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SyncQuery;
import com.contentful.java.cda.SyncType;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Tls12Implementation;
import com.contentful.java.cda.TlsSocketFactory;
import com.contentful.java.cda.TransformQuery;
import com.contentful.java.cda.Util;
import com.contentful.java.cda.interceptor.AuthorizationHeaderInterceptor;
import com.contentful.java.cda.interceptor.ContentfulUserAgentHeaderInterceptor;
import com.contentful.java.cda.interceptor.ErrorInterceptor;
import com.contentful.java.cda.interceptor.LogInterceptor;
import com.contentful.java.cda.interceptor.UserAgentHeaderInterceptor;
import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.reactivestreams.Publisher;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class CDAClient {
    private static final int CONTENT_TYPE_LIMIT_MAX = 1000;
    final String spaceId;
    final String environmentId;
    final String token;
    final CDAService service;
    final Cache cache;
    final Executor callbackExecutor;
    final boolean preview;
    final boolean logSensitiveData;

    CDAClient(Builder builder) {
        this(new Cache(), Platform.get().callbackExecutor(), CDAClient.createService(builder), builder);
        this.validate(builder);
    }

    CDAClient(Cache cache, Executor executor, CDAService service, Builder builder) {
        this.cache = cache;
        this.callbackExecutor = executor;
        this.service = service;
        this.spaceId = builder.space;
        this.environmentId = builder.environment;
        this.token = builder.token;
        this.preview = builder.preview;
        this.logSensitiveData = builder.logSensitiveData;
    }

    private void validate(Builder builder) {
        Util.checkNotNull(builder.space, "Space ID must be provided.", new Object[0]);
        Util.checkNotNull(builder.environment, "Environment ID must not be null.", new Object[0]);
        if (builder.callFactory == null) {
            Util.checkNotNull(builder.token, "A token must be provided, if no call factory is specified.", new Object[0]);
        }
    }

    private static CDAService createService(Builder clientBuilder) {
        String endpoint = clientBuilder.endpoint;
        if (endpoint == null) {
            endpoint = "https://cdn.contentful.com/";
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().addConverterFactory(clientBuilder.createOrGetConverterFactory(clientBuilder)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.createSynchronous()).callFactory(clientBuilder.createOrGetCallFactory(clientBuilder)).baseUrl(endpoint);
        return (CDAService)retrofitBuilder.build().create(CDAService.class);
    }

    public <T extends CDAResource> FetchQuery<T> fetch(Class<T> type) {
        return new FetchQuery<T>(type, this);
    }

    public <T> TransformQuery<T> observeAndTransform(Class<T> type) {
        return new TransformQuery<T>(type, this);
    }

    public <T extends CDAResource> ObserveQuery<T> observe(Class<T> type) {
        return new ObserveQuery<T>(type, this);
    }

    public int populateContentTypeCache() {
        return (Integer)this.observeContentTypeCachePopulation().blockingFirst();
    }

    public int populateContentTypeCache(int limit) {
        if (limit > 1000) {
            throw new IllegalArgumentException("Content types per page limit cannot be more then 1000.");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Content types per page limit cannot be less or equal to 0.");
        }
        return (Integer)this.observeContentTypeCachePopulation(limit).blockingFirst();
    }

    public Flowable<Integer> observeContentTypeCachePopulation() {
        return this.observeContentTypeCachePopulation(1000);
    }

    public Flowable<Integer> observeContentTypeCachePopulation(final int limit) {
        if (limit > 1000) {
            throw new IllegalArgumentException("Content types per page limit cannot be more then 1000.");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Content types per page limit cannot be less or equal to 0.");
        }
        return ((ObserveQuery)((ObserveQuery)this.observe(CDAContentType.class).orderBy("sys.id")).limit(limit)).all().map((Function)new Function<CDAArray, CDAArray>(){

            public CDAArray apply(CDAArray array) {
                if (array.skip() + array.limit() < array.total()) {
                    return this.nextPage(array);
                }
                return array;
            }

            private CDAArray nextPage(CDAArray array) {
                CDAArray nextArray = (CDAArray)((ObserveQuery)((ObserveQuery)((ObserveQuery)CDAClient.this.observe(CDAContentType.class).orderBy("sys.id")).limit(limit)).skip(array.skip + limit)).all().map((Function)this).blockingFirst();
                array.skip = nextArray.skip;
                array.items.addAll(nextArray.items);
                array.assets.putAll(nextArray.assets);
                array.entries.putAll(nextArray.entries);
                return array;
            }
        }).map((Function)new Function<CDAArray, Integer>(){

            public Integer apply(CDAArray array) {
                for (CDAResource resource : array.items) {
                    if (resource instanceof CDAContentType) {
                        CDAClient.this.cache.types().put(resource.id(), (CDAContentType)resource);
                        continue;
                    }
                    throw new IllegalStateException("Requesting a list of content types should not return any other type.");
                }
                return array.total;
            }
        });
    }

    public SyncQuery sync() {
        return this.sync(null, null);
    }

    public SyncQuery sync(SyncType type) {
        return this.sync(null, null, type);
    }

    public boolean shouldLogSensitiveData() {
        return this.logSensitiveData;
    }

    public SyncQuery sync(String syncToken) {
        return this.sync(syncToken, null);
    }

    public SyncQuery sync(SynchronizedSpace synchronizedSpace) {
        return this.sync(null, synchronizedSpace);
    }

    private SyncQuery sync(String syncToken, SynchronizedSpace synchronizedSpace) {
        return this.sync(syncToken, synchronizedSpace, null);
    }

    private SyncQuery sync(String syncToken, SynchronizedSpace synchronizedSpace, SyncType type) {
        if (this.preview) {
            syncToken = null;
            synchronizedSpace = null;
        }
        SyncQuery.Builder builder = SyncQuery.builder().setClient(this);
        if (synchronizedSpace != null) {
            builder.setSpace(synchronizedSpace);
        }
        if (syncToken != null) {
            builder.setSyncToken(syncToken);
        }
        if (type != null) {
            builder.setType(type);
        }
        return builder.build();
    }

    public CDASpace fetchSpace() {
        return (CDASpace)this.observeSpace().blockingFirst();
    }

    public <C extends CDACallback<CDASpace>> C fetchSpace(C callback) {
        return (C)Callbacks.subscribeAsync(this.observeSpace(), callback, this);
    }

    public Flowable<CDASpace> observeSpace() {
        return this.service.space(this.spaceId).map((Function)new Function<Response<CDASpace>, CDASpace>(){

            public CDASpace apply(Response<CDASpace> response) throws Exception {
                return ResourceFactory.fromResponse(response);
            }
        });
    }

    Flowable<Cache> cacheAll(final boolean invalidate) {
        return this.cacheLocales(invalidate).flatMap((Function)new Function<List<CDALocale>, Publisher<? extends Map<String, CDAContentType>>>(){

            public Publisher<? extends Map<String, CDAContentType>> apply(List<CDALocale> locales) {
                return CDAClient.this.cacheTypes(invalidate);
            }
        }).map((Function)new Function<Map<String, CDAContentType>, Cache>(){

            public Cache apply(Map<String, CDAContentType> stringCDAContentTypeMap) {
                return CDAClient.this.cache;
            }
        });
    }

    Flowable<List<CDALocale>> cacheLocales(boolean invalidate) {
        List<CDALocale> locales;
        List<CDALocale> list = locales = invalidate ? null : this.cache.locales();
        if (locales == null) {
            return this.service.array(this.spaceId, this.environmentId, "locales", new HashMap<String, String>()).map((Function)new Function<Response<CDAArray>, List<CDALocale>>(){

                public List<CDALocale> apply(Response<CDAArray> localesResponse) {
                    List<CDALocale> locales1 = ResourceFactory.fromArrayToItems(ResourceFactory.fromResponse(localesResponse));
                    CDAClient.this.cache.setLocales(locales1);
                    return locales1;
                }
            });
        }
        return Flowable.just(locales);
    }

    Flowable<Map<String, CDAContentType>> cacheTypes(boolean invalidate) {
        Map<String, CDAContentType> types;
        Map<String, CDAContentType> map = types = invalidate ? null : this.cache.types();
        if (types == null) {
            return this.service.array(this.spaceId, this.environmentId, "content_types", new HashMap<String, String>()).map((Function)new Function<Response<CDAArray>, Map<String, CDAContentType>>(){

                public Map<String, CDAContentType> apply(Response<CDAArray> arrayResponse) {
                    CDAArray array = ResourceFactory.array(arrayResponse, CDAClient.this);
                    ConcurrentHashMap<String, CDAContentType> tmp = new ConcurrentHashMap<String, CDAContentType>();
                    for (CDAResource resource : array.items()) {
                        tmp.put(resource.id(), (CDAContentType)resource);
                    }
                    CDAClient.this.cache.setTypes(tmp);
                    return tmp;
                }
            });
        }
        return Flowable.just(types);
    }

    Flowable<CDAContentType> cacheTypeWithId(String id) {
        CDAContentType contentType = this.cache.types().get(id);
        if (contentType == null) {
            return this.observe(CDAContentType.class).one(id).map((Function)new Function<CDAContentType, CDAContentType>(){

                public CDAContentType apply(CDAContentType resource) {
                    if (resource != null) {
                        CDAClient.this.cache.types().put(resource.id(), resource);
                    }
                    return resource;
                }
            });
        }
        return Flowable.just((Object)contentType);
    }

    public CDAClient clearCache() {
        this.cache.clear();
        return this;
    }

    static String createUserAgent() {
        Properties properties = System.getProperties();
        return String.format("contentful.java/%s(%s %s) %s/%s", "10.5.18", properties.getProperty("java.runtime.name"), properties.getProperty("java.runtime.version"), properties.getProperty("os.name"), properties.getProperty("os.version"));
    }

    static ContentfulUserAgentHeaderInterceptor.Section[] createCustomHeaderSections(ContentfulUserAgentHeaderInterceptor.Section application, ContentfulUserAgentHeaderInterceptor.Section integration) {
        Properties properties = System.getProperties();
        Platform platform = Platform.get();
        return new ContentfulUserAgentHeaderInterceptor.Section[]{ContentfulUserAgentHeaderInterceptor.Section.sdk("contentful.java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse("10.5.18")), ContentfulUserAgentHeaderInterceptor.Section.platform("java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse(properties.getProperty("java.runtime.version"))), ContentfulUserAgentHeaderInterceptor.Section.os(ContentfulUserAgentHeaderInterceptor.Section.OperatingSystem.parse(platform.name()), ContentfulUserAgentHeaderInterceptor.Section.Version.parse(platform.version())), application, integration};
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String space;
        String environment = "master";
        String token;
        String endpoint;
        Logger logger;
        Logger.Level logLevel = Logger.Level.NONE;
        Call.Factory callFactory;
        Converter.Factory converterFactory;
        boolean preview;
        private boolean logSensitiveData = true;
        Tls12Implementation tls12Implementation = Tls12Implementation.useRecommendation;
        ContentfulUserAgentHeaderInterceptor.Section application;
        ContentfulUserAgentHeaderInterceptor.Section integration;
        private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();

        Builder() {
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setLogSensitiveData(boolean logSensitiveData) {
            this.logSensitiveData = logSensitiveData;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setLogLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder preview() {
            this.preview = true;
            return this.setEndpoint("https://preview.contentful.com/");
        }

        public Builder setCallFactory(Call.Factory callFactory) {
            this.callFactory = callFactory;
            return this;
        }

        Call.Factory createOrGetCallFactory(Builder clientBuilder) {
            Object callFactory = clientBuilder.callFactory == null ? this.defaultCallFactoryBuilder().build() : clientBuilder.callFactory;
            return callFactory;
        }

        public Builder setConverterFactory(Converter.Factory converterFactory) {
            this.converterFactory = converterFactory;
            return this;
        }

        Converter.Factory createOrGetConverterFactory(Builder clientBuilder) {
            Object converterFactory = clientBuilder.converterFactory == null ? GsonConverterFactory.create((Gson)ResourceFactory.GSON) : clientBuilder.converterFactory;
            return converterFactory;
        }

        private OkHttpClient.Builder setLogger(OkHttpClient.Builder okBuilder) {
            if (this.logger != null) {
                switch (this.logLevel) {
                    case BASIC: {
                        return okBuilder.addInterceptor((Interceptor)new LogInterceptor(this.logger));
                    }
                    case FULL: {
                        return okBuilder.addNetworkInterceptor((Interceptor)new LogInterceptor(this.logger));
                    }
                    case NONE: {
                        break;
                    }
                }
            } else if (this.logLevel != Logger.Level.NONE) {
                throw new IllegalArgumentException("Cannot log to a null logger. Please set either logLevel to None, or do set a Logger");
            }
            return okBuilder;
        }

        private OkHttpClient.Builder useTls12IfWanted(OkHttpClient.Builder okBuilder) {
            if (this.isSdkTlsSocketFactoryWanted()) {
                try {
                    okBuilder.sslSocketFactory((SSLSocketFactory)new TlsSocketFactory(), this.getX509TrustManager());
                }
                catch (GeneralSecurityException exception) {
                    throw new IllegalArgumentException("Cannot create TlsSocketFactory for TLS 1.2. Please consider using 'setTls12Implementation(systemProvided)', or update to a system providing TLS 1.2 support.", exception);
                }
            }
            return okBuilder;
        }

        X509TrustManager getX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            return this.extractX509TrustManager(trustManagerFactory.getTrustManagers());
        }

        X509TrustManager extractX509TrustManager(TrustManager[] trustManagers) throws NoSuchAlgorithmException {
            if (trustManagers != null) {
                for (TrustManager manager : trustManagers) {
                    if (!(manager instanceof X509TrustManager)) continue;
                    return (X509TrustManager)manager;
                }
            }
            throw new NoSuchAlgorithmException("Cannot find a 'X509TrustManager' in system provided managers: '" + Arrays.toString(trustManagers) + "'.");
        }

        boolean isSdkTlsSocketFactoryWanted() {
            switch (this.tls12Implementation) {
                case sdkProvided: {
                    return true;
                }
                case systemProvided: {
                    return false;
                }
            }
            return Platform.get().needsCustomTLSSocketFactory();
        }

        public OkHttpClient.Builder defaultCallFactoryBuilder() {
            ContentfulUserAgentHeaderInterceptor.Section[] sections = CDAClient.createCustomHeaderSections(this.application, this.integration);
            OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().connectionPool(OK_HTTP_CLIENT.connectionPool()).addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(this.token)).addInterceptor((Interceptor)new UserAgentHeaderInterceptor(CDAClient.createUserAgent())).addInterceptor((Interceptor)new ContentfulUserAgentHeaderInterceptor(sections)).addInterceptor((Interceptor)new ErrorInterceptor(this.logSensitiveData));
            this.setLogger(okBuilder);
            this.useTls12IfWanted(okBuilder);
            return okBuilder;
        }

        public Builder setTls12Implementation(Tls12Implementation implementation) {
            this.tls12Implementation = implementation;
            return this;
        }

        public Builder setApplication(String name, String version) {
            this.application = ContentfulUserAgentHeaderInterceptor.Section.app(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public Builder setIntegration(String name, String version) {
            this.integration = ContentfulUserAgentHeaderInterceptor.Section.integration(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public CDAClient build() {
            return new CDAClient(this);
        }
    }
}

