/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.ResourceDeserializer;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.rich.RichTextFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import retrofit2.Response;

public final class ResourceFactory {
    static final Gson GSON = ResourceFactory.createGson();

    public ResourceFactory() {
        throw new AssertionError();
    }

    public static CDAArray array(Response<CDAArray> arrayResponse, CDAClient client) {
        CDAArray array = (CDAArray)arrayResponse.body();
        array.assets = new LinkedHashMap();
        array.entries = new LinkedHashMap();
        Set<CDAResource> resources = ResourceFactory.collectResources(array);
        ResourceUtils.localizeResources(resources, client.cache);
        ResourceUtils.mapResources(resources, array.assets, array.entries);
        ResourceUtils.setRawFields(array);
        RichTextFactory.resolveRichTextField(array, client);
        ResourceUtils.resolveLinks(array, client);
        return array;
    }

    public static CDAArray arrayFromJson(CDAArray array, CDAClient client) {
        array.assets = new LinkedHashMap();
        array.entries = new LinkedHashMap();
        Set<CDAResource> resources = ResourceFactory.collectResources(array);
        ResourceUtils.localizeResources(resources, client.cache);
        ResourceUtils.mapResources(resources, array.assets, array.entries);
        ResourceUtils.setRawFields(array);
        RichTextFactory.resolveRichTextField(array, client);
        ResourceUtils.resolveLinks(array, client);
        return array;
    }

    private static Set<CDAResource> collectResources(CDAArray array) {
        LinkedHashSet<CDAResource> resources = new LinkedHashSet<CDAResource>(array.items());
        if (array.includes != null) {
            if (array.includes.assets != null) {
                resources.addAll(array.includes.assets);
            }
            if (array.includes.entries != null) {
                resources.addAll(array.includes.entries);
            }
        }
        return resources;
    }

    static SynchronizedSpace sync(Response<SynchronizedSpace> newSpace, SynchronizedSpace oldSpace, CDAClient client, Integer limit) {
        HashMap<String, CDAAsset> assets = new HashMap<String, CDAAsset>();
        HashMap<String, CDAEntry> entries = new HashMap<String, CDAEntry>();
        if (oldSpace != null) {
            ResourceUtils.mapResources(oldSpace.items(), assets, entries);
        }
        SynchronizedSpace result = ResourceUtils.iterate(newSpace, client, limit);
        ResourceUtils.mapResources(result.items(), assets, entries);
        ResourceUtils.mapDeletedResources(result);
        ArrayList items = new ArrayList();
        items.addAll(assets.values());
        items.addAll(entries.values());
        result.items = items;
        result.assets = assets;
        result.entries = entries;
        ResourceUtils.setRawFields(result);
        RichTextFactory.resolveRichTextField(result, client);
        ResourceUtils.resolveLinks(result, client);
        return result;
    }

    static <T extends CDAResource> T fromResponse(Response<T> response) {
        return (T)((CDAResource)response.body());
    }

    static <T extends CDAResource> List<T> fromArrayToItems(CDAArray array) {
        ArrayList<CDAResource> result = new ArrayList<CDAResource>(array.items.size());
        for (CDAResource resource : array.items) {
            result.add(resource);
        }
        return result;
    }

    public static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(CDAResource.class, (Object)new ResourceDeserializer()).disableHtmlEscaping().create();
    }
}

