/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SyncType;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Util;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import org.reactivestreams.Publisher;
import retrofit2.Response;

public class SyncQuery {
    final CDAClient client;
    final String syncToken;
    final SynchronizedSpace space;
    final boolean initial;
    final SyncType type;
    final Integer limit;

    SyncQuery(Builder builder) {
        this.client = Util.checkNotNull(builder.client, "Client must not be null.", new Object[0]);
        this.syncToken = builder.syncToken;
        this.space = builder.space;
        this.initial = builder.isInitial();
        this.type = builder.type;
        this.limit = builder.limit;
    }

    public Flowable<SynchronizedSpace> observe() {
        String token;
        if (this.space != null) {
            String nextSyncUrl = this.space.nextSyncUrl();
            if (nextSyncUrl == null) {
                throw new IllegalArgumentException("Provided space for synchronization is corrupt.");
            }
            token = Util.queryParam(this.space.nextSyncUrl(), "sync_token");
        } else {
            token = this.syncToken;
        }
        return this.client.cacheAll(true).flatMap((Function)new Function<Cache, Publisher<Response<SynchronizedSpace>>>(){

            public Publisher<Response<SynchronizedSpace>> apply(Cache cache) {
                return SyncQuery.this.client.service.sync(SyncQuery.this.client.spaceId, SyncQuery.this.client.environmentId, SyncQuery.this.initial ? Boolean.valueOf(SyncQuery.this.initial) : null, token, SyncQuery.this.initial && SyncQuery.this.type != null ? SyncQuery.this.type.getName() : null, SyncQuery.this.initial && SyncQuery.this.type != null ? SyncQuery.this.type.getContentType() : null, SyncQuery.this.initial ? SyncQuery.this.limit : null);
            }
        }).map((Function)new Function<Response<SynchronizedSpace>, SynchronizedSpace>(){

            public SynchronizedSpace apply(Response<SynchronizedSpace> synchronizedSpace) {
                return ResourceFactory.sync(synchronizedSpace, SyncQuery.this.space, SyncQuery.this.client, SyncQuery.this.limit);
            }
        });
    }

    public SynchronizedSpace fetch() {
        return (SynchronizedSpace)this.observe().blockingFirst();
    }

    public <C extends CDACallback<SynchronizedSpace>> C fetch(C callback) {
        return (C)Callbacks.subscribeAsync(this.observe(), callback, this.client);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        CDAClient client;
        String syncToken;
        SynchronizedSpace space;
        SyncType type;
        Integer limit;

        Builder() {
        }

        Builder setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        Builder setClient(CDAClient client) {
            this.client = client;
            return this;
        }

        Builder setSyncToken(String syncToken) {
            this.syncToken = syncToken;
            return this;
        }

        Builder setSpace(SynchronizedSpace space) {
            this.space = space;
            return this;
        }

        Builder setType(SyncType type) {
            if (this.isInitial()) {
                this.type = type;
            }
            return this;
        }

        boolean isInitial() {
            return this.space == null && this.syncToken == null;
        }

        SyncQuery build() {
            return new SyncQuery(this);
        }
    }
}

