/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.AbsQuery;
import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAResourceNotFoundException;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.ObserveQuery;
import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransformQuery<Transformed>
extends AbsQuery<Transformed, TransformQuery<Transformed>> {
    private final String contentTypeId;
    private final Map<String, Object> instanceCache = new HashMap<String, Object>();
    private final Map<String, Class<?>> customClassByContentTypeIdCache = new HashMap();

    TransformQuery(Class<Transformed> type, CDAClient client) {
        super(type, client);
        ContentfulEntryModel model = type.getAnnotation(ContentfulEntryModel.class);
        if (model == null) {
            throw new IllegalArgumentException("Cannot transform a class without ContentfulEntryModel annotation.");
        }
        try {
            type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create new instance of custom model.", e);
        }
        this.contentTypeId = model.value();
        this.withContentType(this.contentTypeId);
        for (Field field : type.getDeclaredFields()) {
            ContentfulField annotation = field.getAnnotation(ContentfulField.class);
            if (annotation != null) {
                this.parseFieldAnnotation(field, annotation);
                continue;
            }
            ContentfulSystemField systemField = field.getAnnotation(ContentfulSystemField.class);
            if (systemField != null) {
                this.parseSystemFieldAnnotation(field, systemField);
                continue;
            }
            ContentfulMetadata metadata = field.getAnnotation(ContentfulMetadata.class);
            if (metadata == null) continue;
            this.parseMetadataAnnotation(metadata);
        }
        this.createCustomClassCache(type);
    }

    private void createCustomClassCache(Class<?> seedType) {
        ContentfulEntryModel seedAnnotation = seedType.getAnnotation(ContentfulEntryModel.class);
        if (seedAnnotation == null) {
            throw new IllegalStateException("Custom class has to be annotated with 'ContentfulEntryModel' annotation");
        }
        if (this.customClassByContentTypeIdCache.containsKey(seedAnnotation.value())) {
            return;
        }
        for (Class<?> model : seedAnnotation.additionalModelHints()) {
            ContentfulEntryModel modelAnnotation = model.getAnnotation(ContentfulEntryModel.class);
            if (modelAnnotation == null) continue;
            this.customClassByContentTypeIdCache.put(modelAnnotation.value(), model);
        }
        String contentTypeId = seedAnnotation.value();
        this.customClassByContentTypeIdCache.put(contentTypeId, seedType);
        for (Field field : seedType.getDeclaredFields()) {
            if (this.isFieldACollection(field)) {
                ContentfulEntryModel itemAnnotation;
                Class<?> itemType = this.getCollectionFieldEntryType(field);
                if (itemType == null || (itemAnnotation = itemType.getAnnotation(ContentfulEntryModel.class)) == null) continue;
                this.createCustomClassCache(itemType);
                continue;
            }
            ContentfulEntryModel fieldCustomAnnotation = field.getType().getAnnotation(ContentfulEntryModel.class);
            if (fieldCustomAnnotation == null) continue;
            this.createCustomClassCache(field.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getCollectionFieldEntryType(Field field) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            String genericType = field.getGenericType().toString();
            String genericSubTypeRegex = "^[.\\p{Alpha}]+<(?<subtype>.+)>$";
            Pattern pattern = Pattern.compile((String)"^[.\\p{Alpha}]+<(?<subtype>.+)>$");
            Matcher matcher = pattern.matcher((CharSequence)genericType);
            if (matcher.matches()) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(matcher.group("subtype"));
                return clazz;
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (Throwable t) {
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    private boolean isFieldACollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    private void parseFieldAnnotation(Field field, ContentfulField annotation) {
        String name = annotation.value().isEmpty() ? field.getName() : annotation.value();
        this.select("fields." + name);
    }

    private void parseSystemFieldAnnotation(Field field, ContentfulSystemField annotation) {
        String name = annotation.value().isEmpty() ? field.getName() : annotation.value();
        this.select("sys." + name);
    }

    private void parseMetadataAnnotation(ContentfulMetadata annotation) {
        this.select(annotation.value());
    }

    public Flowable<Transformed> one(String id) {
        try {
            return this.baseQuery().one(id).filter((Predicate)new Predicate<CDAEntry>(){

                public boolean test(CDAEntry entry) {
                    return entry.contentType().id().equals(TransformQuery.this.contentTypeId);
                }
            }).map(new Function<CDAEntry, Transformed>(){

                public Transformed apply(CDAEntry entry) throws Exception {
                    return TransformQuery.this.transform(entry);
                }
            });
        }
        catch (NullPointerException e) {
            throw new CDAResourceNotFoundException(CDAEntry.class, id);
        }
    }

    public CDACallback<Transformed> one(String id, CDACallback<Transformed> callback) {
        return Callbacks.subscribeAsync(this.baseQuery().one(id).filter((Predicate)new Predicate<CDAEntry>(){

            public boolean test(CDAEntry entry) {
                return entry.contentType().id().equals(TransformQuery.this.contentTypeId);
            }
        }).map(this::transform), callback, this.client);
    }

    public Flowable<Collection<Transformed>> all() {
        return this.baseQuery().all().map(new Function<CDAArray, Collection<Transformed>>(){

            public Collection<Transformed> apply(CDAArray array) {
                ArrayList<Object> result = new ArrayList<Object>(array.total());
                for (CDAResource resource : array.items) {
                    if (!(resource instanceof CDAEntry) || !((CDAEntry)resource).contentType().id().equals(TransformQuery.this.contentTypeId)) continue;
                    result.add(TransformQuery.this.transform((CDAEntry)resource));
                }
                return result;
            }
        });
    }

    public CDACallback<Collection<Transformed>> all(CDACallback<Collection<Transformed>> callback) {
        return Callbacks.subscribeAsync(this.baseQuery().all().map(new Function<CDAArray, List<Transformed>>(){

            public List<Transformed> apply(CDAArray array) {
                ArrayList<Object> result = new ArrayList<Object>(array.total());
                for (CDAResource resource : array.items) {
                    if (!(resource instanceof CDAEntry) || !((CDAEntry)resource).contentType().id().equals(TransformQuery.this.contentTypeId)) continue;
                    result.add(TransformQuery.this.transform((CDAEntry)resource));
                }
                return result;
            }
        }), callback, this.client);
    }

    private ObserveQuery<CDAEntry> baseQuery() {
        return (ObserveQuery)this.client.observe(CDAEntry.class).where(this.params);
    }

    private Object transform(CDAEntry entry) {
        Object result;
        if (!this.customClassByContentTypeIdCache.containsKey(entry.contentType().id())) {
            return entry;
        }
        Class<?> type = this.customClassByContentTypeIdCache.get(entry.contentType().id());
        if (this.instanceCache.containsKey(entry.id())) {
            result = this.instanceCache.get(entry.id());
        } else {
            ContentfulMetadata metadata;
            ContentfulSystemField systemField;
            ContentfulField annotation;
            try {
                result = type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot transform entry " + entry + "  to type " + type.getCanonicalName(), e);
            }
            this.instanceCache.put(entry.id(), result);
            for (Field field : type.getDeclaredFields()) {
                annotation = field.getAnnotation(ContentfulField.class);
                if (annotation != null) {
                    this.transformFieldAnnotation(entry, result, field, annotation);
                    continue;
                }
                systemField = field.getAnnotation(ContentfulSystemField.class);
                if (systemField != null) {
                    this.transformSystemFieldAnnotation(entry, result, field, systemField);
                    continue;
                }
                metadata = field.getAnnotation(ContentfulMetadata.class);
                if (metadata == null) continue;
                this.transformMetadataAnnotation(entry, result, field, metadata);
            }
            for (Field field : type.getSuperclass().getDeclaredFields()) {
                annotation = field.getAnnotation(ContentfulField.class);
                if (annotation != null) {
                    this.transformFieldAnnotation(entry, result, field, annotation);
                    continue;
                }
                systemField = field.getAnnotation(ContentfulSystemField.class);
                if (systemField != null) {
                    this.transformSystemFieldAnnotation(entry, result, field, systemField);
                    continue;
                }
                metadata = field.getAnnotation(ContentfulMetadata.class);
                if (metadata == null) continue;
                this.transformMetadataAnnotation(entry, result, field, metadata);
            }
        }
        return result;
    }

    private void transformFieldAnnotation(CDAEntry entry, Object result, Field field, ContentfulField annotation) {
        boolean wasAccessible = field.isAccessible();
        field.setAccessible(true);
        String key = annotation.value().isEmpty() ? field.getName() : annotation.value();
        String locale = annotation.locale().isEmpty() ? entry.defaultLocale : annotation.locale();
        try {
            Object value = entry.getField(locale, key);
            if (value instanceof CDAEntry) {
                CDAEntry fieldEntry = (CDAEntry)value;
                if (!this.instanceCache.containsKey(fieldEntry.id())) {
                    this.transform(fieldEntry);
                }
                try {
                    field.set(result, this.instanceCache.get(fieldEntry.id()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                ArrayList<Object> transformedList = new ArrayList<Object>(collection.size());
                for (Object element : collection) {
                    if (element instanceof CDAEntry) {
                        CDAEntry collectionEntry = (CDAEntry)element;
                        if (this.customClassByContentTypeIdCache.containsKey(collectionEntry.contentType().id())) {
                            transformedList.add(this.transform(collectionEntry));
                            continue;
                        }
                        transformedList.add(element);
                        continue;
                    }
                    transformedList.add(element);
                }
                try {
                    field.set(result, transformedList);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                try {
                    field.set(result, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set custom field " + key + ".");
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    private void transformSystemFieldAnnotation(CDAEntry entry, Object result, Field field, ContentfulSystemField annotation) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        String key = annotation.value().isEmpty() ? field.getName() : annotation.value();
        try {
            field.set(result, entry.getAttribute(key));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set custom system field " + key + ".");
        }
    }

    private void transformMetadataAnnotation(CDAEntry entry, Object result, Field field, ContentfulMetadata annotation) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        String key = annotation.value();
        try {
            field.set(result, entry.metadata());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set " + key + ".");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulEntryModel {
        public String value();

        public Class<?>[] additionalModelHints() default {};
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulField {
        public String value() default "";

        public String locale() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulSystemField {
        public String value() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulMetadata {
        public String value() default "metadata";
    }
}

