/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

public class SyncType {
    final Type type;
    final String contentType;

    SyncType(Type type, String contentType) {
        this.type = type;
        this.contentType = contentType;
    }

    public static SyncType allAssets() {
        return new SyncType(Type.Asset, null);
    }

    public static SyncType allEntries() {
        return new SyncType(Type.Entry, null);
    }

    public static SyncType onlyEntriesOfType(String type) {
        return new SyncType(Type.Entry, type);
    }

    public static SyncType onlyDeletion() {
        return new SyncType(Type.Deletion, null);
    }

    public static SyncType onlyDeletedAssets() {
        return new SyncType(Type.DeletedAsset, null);
    }

    public static SyncType onlyDeletedEntries() {
        return new SyncType(Type.DeletedEntry, null);
    }

    public String getName() {
        return this.type.name();
    }

    public String getContentType() {
        return this.contentType;
    }

    public static enum Type {
        Asset,
        Entry,
        Deletion,
        DeletedAsset,
        DeletedEntry;

    }
}

