/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk.converter;

import com.contentgrid.opa.client.rest.http.HttpRequestHeaders;
import com.contentgrid.opa.client.rest.http.MediaType;
import java.util.Collection;
import java.util.Objects;

public interface HttpBodyConverter {
    public <T> boolean canRead(DeserializationContext var1, Class<T> var2);

    public <T> T read(DeserializationContext var1, Class<T> var2);

    public boolean canWrite(SerializationContext var1);

    public byte[] write(SerializationContext var1);

    public Collection<MediaType> getSupportedMediaTypes();

    default public boolean supportsMediaType(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    public static interface SerializationContext {
        public Object getSource();

        public HttpRequestHeaders getHeaders();

        default public MediaType getContentType() {
            return this.getHeaders().contentType().orElse(null);
        }

        default public boolean isEmpty() {
            return Objects.isNull(this.getSource());
        }

        public static SerializationContext of(final Object source, final HttpRequestHeaders requestHeaders) {
            return new SerializationContext(){

                @Override
                public Object getSource() {
                    return source;
                }

                @Override
                public HttpRequestHeaders getHeaders() {
                    return requestHeaders;
                }
            };
        }
    }

    public static interface DeserializationContext {
        public MediaType getContentType();

        public byte[] getSource();

        public static DeserializationContext of(final byte[] source, final MediaType contentType) {
            return new DeserializationContext(){

                @Override
                public MediaType getContentType() {
                    return contentType;
                }

                @Override
                public byte[] getSource() {
                    return source;
                }
            };
        }
    }
}

