/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.http;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MediaType {
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final MediaType TEXT_ALL = new MediaType("text", "*");
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    protected static final String WILDCARD = "*";
    private static final String PARAM_CHARSET = "charset";
    private static final String PARAM_Q = "q";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private Charset charset;

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        MediaType.assertNotEmpty(type, "'type' must not be empty");
        MediaType.assertNotEmpty(subtype, "'subtype' must not be empty");
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.subtype = subtype.toLowerCase(Locale.ENGLISH);
        if (parameters.isEmpty()) {
            this.parameters = Collections.emptyMap();
        } else {
            this.parameters = new LinkedHashMap<String, String>();
            parameters.forEach((key, value) -> {
                this.checkParameters((String)key, (String)value);
                this.parameters.put((String)key, (String)value);
            });
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    public boolean isWildcardSubtype() {
        return WILDCARD.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public double getQualityValue() {
        String qualityFactor = this.getParameter(PARAM_Q);
        return qualityFactor != null ? Double.parseDouble(MediaType.unquote(qualityFactor)) : 1.0;
    }

    public boolean includes(MediaType other) {
        if (other == null) {
            return false;
        }
        if (WILDCARD.equals(this.getType())) {
            return true;
        }
        if (this.getType().equals(other.getType())) {
            if (this.getSubtype().equals(other.getSubtype())) {
                return true;
            }
            if (WILDCARD.equals(this.getSubtype())) {
                return true;
            }
            if (this.getSubtype().startsWith("*+")) {
                int thisPlusIdx = this.getSubtype().indexOf(43);
                int otherPlusIdx = other.getSubtype().indexOf(43);
                if (otherPlusIdx != -1) {
                    String thisSubtypeSuffix = this.getSubtype().substring(thisPlusIdx + 1);
                    String otherSubtypeSuffix = other.getSubtype().substring(otherPlusIdx + 1);
                    return thisSubtypeSuffix.equals(otherSubtypeSuffix);
                }
            }
        }
        return false;
    }

    public static MediaType parseMediaType(String mediaType) {
        int nextIndex;
        int subIndex;
        int index = mediaType.indexOf(59);
        String fullType = (index >= 0 ? mediaType.substring(0, index) : mediaType).trim();
        if (fullType.isEmpty()) {
            throw new IllegalArgumentException("Invalid media type '" + mediaType + "': 'mediaType' must not be empty");
        }
        if (WILDCARD.equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new IllegalArgumentException("Invalid media type '" + mediaType + "': does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new IllegalArgumentException("Invalid media type '" + mediaType + "': does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1);
        if (WILDCARD.equals(type) && !WILDCARD.equals(subtype)) {
            throw new IllegalArgumentException("Invalid media type '" + mediaType + "': wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(4);
        do {
            int eqIndex;
            String parameter;
            boolean quoted = false;
            for (nextIndex = index + 1; nextIndex < mediaType.length(); ++nextIndex) {
                char ch = mediaType.charAt(nextIndex);
                if (ch == ';') {
                    if (quoted) continue;
                    break;
                }
                if (ch != '\"') continue;
                quoted = !quoted;
            }
            if ((parameter = mediaType.substring(index + 1, nextIndex).trim()).length() <= 0 || (eqIndex = parameter.indexOf(61)) < 0) continue;
            String attribute = parameter.substring(0, eqIndex).trim();
            String value = parameter.substring(eqIndex + 1).trim();
            parameters.put(attribute, value);
        } while ((index = nextIndex) < mediaType.length());
        return new MediaType(type, subtype, parameters);
    }

    public static List<MediaType> parseMediaTypes(String ... mediaTypes) {
        return Arrays.stream(mediaTypes).map(MediaType::parseMediaType).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.type).append('/').append(this.subtype);
        this.parameters.forEach((key, val) -> sb.append(";").append((String)key).append('=').append((String)val));
        return sb.toString();
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        return mediaTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private void checkParameters(String parameter, String value) {
        MediaType.assertNotEmpty(parameter, "'parameter' must not be empty");
        MediaType.assertNotEmpty(value, "'value' must not be empty");
        RFC7230Tokens.assertIsValidToken(parameter);
        if (PARAM_Q.equals(parameter.toLowerCase(Locale.ENGLISH))) {
            double d = Double.parseDouble(value = MediaType.unquote(value));
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0");
            }
        } else if (PARAM_CHARSET.equals(parameter.toLowerCase(Locale.ENGLISH)) && this.charset == null) {
            this.charset = Charset.forName(MediaType.unquote(value));
        }
    }

    private static void assertNotEmpty(String test, String message) {
        if (test == null || test.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String unquote(String string) {
        return MediaType.isDoubleQuoted(string) ? string.substring(1, string.length() - 1) : string;
    }

    private static boolean isDoubleQuoted(String s) {
        return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"");
    }

    private static final class RFC7230Tokens {
        static final BitSet TOKEN = new BitSet(128);

        private RFC7230Tokens() {
        }

        public static void assertIsValidToken(String token) {
            token.chars().forEach(ch -> {
                if (!TOKEN.get(ch)) {
                    throw new IllegalArgumentException("Invalid token character '" + ch + "' in token \"" + token + "\"");
                }
            });
        }

        static {
            TOKEN.set(33);
            TOKEN.set(35);
            TOKEN.set(36);
            TOKEN.set(37);
            TOKEN.set(38);
            TOKEN.set(39);
            TOKEN.set(42);
            TOKEN.set(43);
            TOKEN.set(45);
            TOKEN.set(46);
            TOKEN.set(94);
            TOKEN.set(95);
            TOKEN.set(96);
            TOKEN.set(124);
            TOKEN.set(126);
            TOKEN.set(48, 58);
            TOKEN.set(97, 123);
            TOKEN.set(65, 91);
        }
    }
}

