/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.impl;

import com.contentgrid.opa.client.api.QueryApi;
import com.contentgrid.opa.client.rest.OpaHttpClient;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class QueryComponent
implements QueryApi {
    private static final String QUERY_ENDPOINT = "/v1/query";
    private final OpaHttpClient httpClient;

    @Override
    public CompletableFuture<QueryApi.QueryResponse> query(String query) {
        return this.query(new QueryRequest(query));
    }

    CompletableFuture<QueryApi.QueryResponse> query(QueryRequest request) {
        return this.httpClient.post(QUERY_ENDPOINT, request, QueryApi.QueryResponse.class);
    }

    public QueryComponent(OpaHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private class QueryRequest {
        @NonNull
        String query;

        @NonNull
        public String getQuery() {
            return this.query;
        }

        public void setQuery(@NonNull String query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryRequest)) {
                return false;
            }
            QueryRequest other = (QueryRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            return !(this$query == null ? other$query != null : !this$query.equals(other$query));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            return result;
        }

        public String toString() {
            return "QueryComponent.QueryRequest(query=" + this.getQuery() + ")";
        }

        public QueryRequest(String query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
        }
    }

    static class AdHocQueryResponse<T> {
        T result;

        public T getResult() {
            return this.result;
        }

        public void setResult(T result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdHocQueryResponse)) {
                return false;
            }
            AdHocQueryResponse other = (AdHocQueryResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$result = this.getResult();
            T other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdHocQueryResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "QueryComponent.AdHocQueryResponse(result=" + this.getResult() + ")";
        }
    }
}

