/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.rego.ast;

import com.contentgrid.opa.rego.ast.Node;
import com.contentgrid.opa.rego.ast.RegoVisitor;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Ref.class, name="ref"), @JsonSubTypes.Type(value=Call.class, name="call"), @JsonSubTypes.Type(value=Var.class, name="var"), @JsonSubTypes.Type(value=Numeric.class, name="number"), @JsonSubTypes.Type(value=Text.class, name="string"), @JsonSubTypes.Type(value=Bool.class, name="boolean"), @JsonSubTypes.Type(value=Null.class, name="null"), @JsonSubTypes.Type(value=ArrayTerm.class, name="array")})
public abstract class Term
implements Node {
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term other = (Term)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Term;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Term()";
    }

    public static class Null
    extends ScalarTerm<Void> {
        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            return "null";
        }

        @Override
        protected Void getValue() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Null)) {
                return false;
            }
            Null other = (Null)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class Numeric
    extends ScalarTerm<BigDecimal> {
        BigDecimal value;

        public Numeric(long number) {
            this(BigDecimal.valueOf(number));
        }

        public Numeric(double number) {
            this(BigDecimal.valueOf(number));
        }

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            return this.getValue().toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Numeric)) {
                return false;
            }
            Numeric other = (Numeric)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BigDecimal this$value = this.getValue();
            BigDecimal other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Numeric;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            BigDecimal $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public Numeric() {
        }

        public Numeric(BigDecimal value) {
            this.value = value;
        }

        @Override
        public BigDecimal getValue() {
            return this.value;
        }
    }

    public static class Bool
    extends ScalarTerm<Boolean> {
        private boolean value;

        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.getValue().toString().toUpperCase(Locale.ROOT);
        }

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        public Bool() {
        }

        public Bool(boolean value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bool)) {
                return false;
            }
            Bool other = (Bool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$value = this.getValue();
            Boolean other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Bool;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }
    }

    public static class Text
    extends ScalarTerm<String> {
        String value;

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            return "\"" + this.getValue() + "\"";
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Text;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public Text() {
        }

        public Text(String value) {
            this.value = value;
        }
    }

    public static abstract class ScalarTerm<T>
    extends Term {
        protected abstract T getValue();

        @Override
        public String toString() {
            return "Term.ScalarTerm()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalarTerm)) {
                return false;
            }
            ScalarTerm other = (ScalarTerm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ScalarTerm;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class ArrayTerm
    extends Term {
        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            return "Term.ArrayTerm()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayTerm)) {
                return false;
            }
            ArrayTerm other = (ArrayTerm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ArrayTerm;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class Var
    extends Term {
        String value;

        @Override
        public String toString() {
            return this.getValue();
        }

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Var)) {
                return false;
            }
            Var other = (Var)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Var;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public Var() {
        }

        public Var(String value) {
            this.value = value;
        }
    }

    public static class Call
    extends Term {
        List<? extends Term> value;

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        public List<? extends Term> getValue() {
            return this.value;
        }

        public void setValue(List<? extends Term> value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "Term.Call(value=" + this.getValue() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Call)) {
                return false;
            }
            Call other = (Call)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<? extends Term> this$value = this.getValue();
            List<? extends Term> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Call;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<? extends Term> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }
    }

    public static class Ref
    extends Term {
        List<Term> value;

        @Override
        public <T> T accept(RegoVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            return this.getValue().get(0) + this.getValue().stream().skip(1L).map(term -> "[" + term.toString() + "]").collect(Collectors.joining());
        }

        public List<Term> getValue() {
            return this.value;
        }

        public void setValue(List<Term> value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ref)) {
                return false;
            }
            Ref other = (Ref)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Term> this$value = this.getValue();
            List<Term> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Ref;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Term> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public Ref() {
        }

        public Ref(List<Term> value) {
            this.value = value;
        }
    }
}

