/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.spring.data.querydsl.predicate.injector.rest.webmvc;

import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.CollectionFilteringOperationPredicates;
import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.OperationPredicates;
import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.QuerydslPredicateResolver;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class QuerydslBindingsPredicateResolver
implements QuerydslPredicateResolver {
    private final QuerydslPredicateBuilder predicateBuilder;
    private final QuerydslBindingsFactory querydslBindingsFactory;

    QuerydslBindingsPredicateResolver(ConversionService conversionService, QuerydslBindingsFactory querydslBindingsFactory) {
        this.predicateBuilder = new QuerydslPredicateBuilder(conversionService, querydslBindingsFactory.getEntityPathResolver());
        this.querydslBindingsFactory = querydslBindingsFactory;
    }

    @Override
    public Optional<OperationPredicates> resolve(MethodParameter methodParameter, Class<?> domainType, Map<String, String[]> parameters) {
        if (!methodParameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            return Optional.empty();
        }
        TypeInformation domainTypeInfo = TypeInformation.of(domainType);
        QuerydslBindings bindings = this.querydslBindingsFactory.createBindingsFor(domainTypeInfo);
        return Optional.of(this.predicateBuilder.getPredicate(domainTypeInfo, QuerydslBindingsPredicateResolver.toMultiValueMap(parameters), bindings)).map(CollectionFilteringOperationPredicates::new);
    }

    private static MultiValueMap<String, String> toMultiValueMap(Map<String, String[]> source) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        for (Map.Entry<String, String[]> entry : source.entrySet()) {
            result.put((Object)entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return result;
    }
}

