/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.encoding.json;

import com.contentgrid.thunx.encoding.json.InvalidExpressionDataException;
import com.contentgrid.thunx.encoding.json.JsonExpressionDto;
import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

class JsonFunctionDto
implements JsonExpressionDto {
    private final String type = "function";
    private String operator;
    private List<JsonExpressionDto> terms = new ArrayList<JsonExpressionDto>();

    public JsonFunctionDto(String operator, List<JsonExpressionDto> terms) {
        this.operator = operator;
        this.terms.addAll(terms);
    }

    public JsonFunctionDto(String operator, Stream<JsonExpressionDto> result) {
        this.operator = operator;
        result.forEach(expr -> this.terms.add((JsonExpressionDto)expr));
    }

    public static JsonFunctionDto of(String operator, JsonExpressionDto left, JsonExpressionDto right) {
        return new JsonFunctionDto(operator, List.of(left, right));
    }

    @Override
    public ThunkExpression<?> toExpression() throws InvalidExpressionDataException {
        ArrayList exprTerms = new ArrayList();
        for (JsonExpressionDto dto : this.terms) {
            exprTerms.add(dto.toExpression());
        }
        FunctionExpression.Operator op = FunctionExpression.Operator.resolve((String)this.operator);
        return op.create(this.terms.stream().map(JsonExpressionDto::toExpression).collect(Collectors.toList()));
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Generated
    public List<JsonExpressionDto> getTerms() {
        return this.terms;
    }

    @Generated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Generated
    public void setTerms(List<JsonExpressionDto> terms) {
        this.terms = terms;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonFunctionDto)) {
            return false;
        }
        JsonFunctionDto other = (JsonFunctionDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        List<JsonExpressionDto> this$terms = this.getTerms();
        List<JsonExpressionDto> other$terms = other.getTerms();
        return !(this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonFunctionDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        List<JsonExpressionDto> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JsonFunctionDto(type=" + this.getType() + ", operator=" + this.getOperator() + ", terms=" + String.valueOf(this.getTerms()) + ")";
    }

    @Generated
    public JsonFunctionDto() {
    }
}

