/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.encoding.json;

import com.contentgrid.thunx.encoding.json.InvalidExpressionDataException;
import com.contentgrid.thunx.encoding.json.JsonExpressionDto;
import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

class JsonScalarDto<T>
implements JsonExpressionDto {
    static final Map<Class<?>, String> SCALAR_TYPES = Map.of(String.class, "string", Number.class, "number", Boolean.class, "bool", Void.class, "null");
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T value;

    public static JsonScalarDto of(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        return new JsonScalarDto<String>(SCALAR_TYPES.get(String.class), string);
    }

    public static JsonScalarDto of(@NonNull Number number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return new JsonScalarDto<Number>(SCALAR_TYPES.get(Number.class), number);
    }

    public static JsonScalarDto of(@NonNull Boolean bool) {
        if (bool == null) {
            throw new NullPointerException("bool is marked non-null but is null");
        }
        return new JsonScalarDto<Boolean>(SCALAR_TYPES.get(Boolean.class), bool);
    }

    public static JsonScalarDto nullValue() {
        return new JsonScalarDto<Object>(SCALAR_TYPES.get(Void.class), null);
    }

    @JsonCreator
    public static JsonScalarDto of(@JsonProperty(value="type") @NonNull String type, @JsonProperty(value="value") Object value) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new JsonScalarDto<Object>(type, value);
    }

    @Override
    public ThunkExpression<?> toExpression() throws InvalidExpressionDataException {
        switch (this.getType()) {
            case "string": {
                if (this.value instanceof String) {
                    return Scalar.of((String)((String)this.value));
                }
                throw new InvalidExpressionDataException.InvalidExpressionValueException(this.value, (Type)((Object)String.class));
            }
            case "number": {
                if (this.value instanceof BigDecimal) {
                    return Scalar.of((BigDecimal)((BigDecimal)this.value));
                }
                if (this.value instanceof Integer) {
                    return Scalar.of((long)((Integer)this.value).intValue());
                }
                if (this.value instanceof Long) {
                    return Scalar.of((long)((Long)this.value));
                }
                if (this.value instanceof Float) {
                    return Scalar.of((double)((Float)this.value).floatValue());
                }
                if (this.value instanceof Double) {
                    return Scalar.of((double)((Double)this.value));
                }
                throw new InvalidExpressionDataException.InvalidExpressionValueException(this.value, (Type)((Object)Number.class));
            }
            case "bool": {
                if (this.value instanceof Boolean) {
                    return Scalar.of((boolean)Boolean.TRUE.equals(this.value));
                }
                throw new InvalidExpressionDataException.InvalidExpressionValueException(this.value, (Type)((Object)Boolean.class));
            }
            case "null": {
                if (this.value != null) {
                    throw new InvalidExpressionDataException.InvalidExpressionValueException(this.value, (Type)((Object)Void.class));
                }
                return Scalar.nullValue();
            }
        }
        String message = String.format("Scalar type '%s' is not supported", this.getType());
        throw new UnsupportedOperationException(message);
    }

    private static ScalarTypes getValidScalarType(String type) throws InvalidExpressionDataException {
        try {
            return ScalarTypes.valueOf(type);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidExpressionDataException.InvalidExpressionTypeException(type, String.format("Scalar type '%s' is not valid", type));
        }
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setValue(T value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonScalarDto)) {
            return false;
        }
        JsonScalarDto other = (JsonScalarDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonScalarDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JsonScalarDto(type=" + this.getType() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Generated
    public JsonScalarDto() {
    }

    @Generated
    public JsonScalarDto(String type, T value) {
        this.type = type;
        this.value = value;
    }

    static enum ScalarTypes {
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }

    private static class EitherSerializer
    extends StdSerializer<Either<String, Number, Boolean, Void>> {
        public EitherSerializer() {
            this(null);
        }

        public EitherSerializer(Class<Either<String, Number, Boolean, Void>> type) {
            super(type);
        }

        public void serialize(Either<String, Number, Boolean, Void> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            value.accept(string -> EitherSerializer.unchecked(() -> gen.writeString(string)), number -> EitherSerializer.unchecked(() -> gen.writeNumber(String.valueOf(number))), bool -> EitherSerializer.unchecked(() -> gen.writeBoolean(bool.booleanValue())), nothing -> EitherSerializer.unchecked(() -> gen.writeNull()));
        }

        private static void unchecked(IOExceptionThrowingRunnable runnable) {
            try {
                runnable.run();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }

        @FunctionalInterface
        static interface IOExceptionThrowingRunnable {
            public void run() throws IOException;
        }
    }

    static class Either<A, B, C, D> {
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        private Either(A a, B b, C c, D d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        static <A, B, C, D> Either<A, B, C, D> first(A a) {
            return new Either<A, Object, Object, Object>(a, null, null, null);
        }

        static <A, B, C, D> Either<A, B, C, D> second(B b) {
            return new Either<Object, B, Object, Object>(null, b, null, null);
        }

        static <A, B, C, D> Either<A, B, C, D> third(C c) {
            return new Either<Object, Object, C, Object>(null, null, c, null);
        }

        static <A, B, C, D> Either<A, B, C, D> fourth(D d) {
            return new Either<Object, Object, Object, D>(null, null, null, d);
        }

        public <T> T map(Function<A, T> aFunc, Function<B, T> bFunc, Function<C, T> cFunc, Function<D, T> dFunc) {
            return (T)Optional.ofNullable(this.a).map(value -> aFunc.apply(value)).or(() -> Optional.ofNullable(this.b).map(value -> bFunc.apply(value))).or(() -> Optional.ofNullable(this.c).map(value -> cFunc.apply(value))).or(() -> Optional.ofNullable(this.d).map(value -> dFunc.apply(value))).orElseThrow();
        }

        public void accept(Consumer<A> aFunc, Consumer<B> bFunc, Consumer<C> cFunc, Consumer<D> dFunc) {
            Optional.ofNullable(this.a).ifPresent(value -> aFunc.accept(value));
            Optional.ofNullable(this.b).ifPresent(value -> bFunc.accept(value));
            Optional.ofNullable(this.c).ifPresent(value -> cFunc.accept(value));
            Optional.ofNullable(this.d).ifPresent(value -> dFunc.accept(value));
        }
    }
}

