/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.encoding.json;

import com.contentgrid.thunx.encoding.json.InvalidExpressionDataException;
import com.contentgrid.thunx.encoding.json.JsonExpressionDto;
import com.contentgrid.thunx.encoding.json.JsonScalarDto;
import com.contentgrid.thunx.encoding.json.JsonVariableDto;
import com.contentgrid.thunx.predicates.model.SymbolicReference;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

class JsonSymbolicReferenceDto
implements JsonExpressionDto {
    private final String type = "ref";
    private JsonExpressionDto subject;
    private List<JsonExpressionDto> path;

    public JsonSymbolicReferenceDto(JsonExpressionDto subject, List<JsonExpressionDto> path) {
        this.subject = subject;
        this.path = path;
    }

    public static JsonSymbolicReferenceDto of(String var, String ... path) {
        return new JsonSymbolicReferenceDto(JsonVariableDto.named(var), Arrays.stream(path).map(p -> JsonScalarDto.of(p)).collect(Collectors.toList()));
    }

    @Override
    public ThunkExpression<?> toExpression() throws InvalidExpressionDataException {
        Variable subj = JsonSymbolicReferenceDto.subjectToExpression(this.subject);
        Stream<SymbolicReference.PathElement> pathElements = JsonSymbolicReferenceDto.pathToExpression(this.path);
        return SymbolicReference.of((Variable)subj, pathElements);
    }

    private static Stream<SymbolicReference.PathElement> pathToExpression(List<JsonExpressionDto> path) {
        return path.stream().map(p -> SymbolicReference.path(p.toExpression()));
    }

    private static Variable subjectToExpression(JsonExpressionDto subject) throws InvalidExpressionDataException {
        ThunkExpression<?> subjectVar = subject.toExpression();
        if (!(subjectVar instanceof Variable)) {
            String message = String.format("Symbolic reference '%s' subject type not supported", subjectVar);
            throw new InvalidExpressionDataException(message);
        }
        return (Variable)subjectVar;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public JsonExpressionDto getSubject() {
        return this.subject;
    }

    @Generated
    public List<JsonExpressionDto> getPath() {
        return this.path;
    }

    @Generated
    public void setSubject(JsonExpressionDto subject) {
        this.subject = subject;
    }

    @Generated
    public void setPath(List<JsonExpressionDto> path) {
        this.path = path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonSymbolicReferenceDto)) {
            return false;
        }
        JsonSymbolicReferenceDto other = (JsonSymbolicReferenceDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        JsonExpressionDto this$subject = this.getSubject();
        JsonExpressionDto other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        List<JsonExpressionDto> this$path = this.getPath();
        List<JsonExpressionDto> other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonSymbolicReferenceDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        JsonExpressionDto $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        List<JsonExpressionDto> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JsonSymbolicReferenceDto(type=" + this.getType() + ", subject=" + String.valueOf(this.getSubject()) + ", path=" + String.valueOf(this.getPath()) + ")";
    }

    @Generated
    public JsonSymbolicReferenceDto() {
    }
}

