/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.encoding.json;

import com.contentgrid.thunx.encoding.ThunkExpressionDecoder;
import com.contentgrid.thunx.encoding.ThunkExpressionEncoder;
import com.contentgrid.thunx.encoding.json.JsonExpressionDto;
import com.contentgrid.thunx.encoding.json.JsonFunctionDto;
import com.contentgrid.thunx.encoding.json.JsonScalarDto;
import com.contentgrid.thunx.encoding.json.JsonSymbolicReferenceDto;
import com.contentgrid.thunx.encoding.json.JsonVariableDto;
import com.contentgrid.thunx.predicates.model.ContextFreeThunkExpressionVisitor;
import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.SymbolicReference;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import com.contentgrid.thunx.predicates.model.Variable;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class JsonThunkExpressionCoder
implements ThunkExpressionEncoder,
ThunkExpressionDecoder {
    private final ObjectMapper objectMapper;
    private static final JsonEncoderVisitor visitor = new JsonEncoderVisitor();

    public JsonThunkExpressionCoder() {
        this(new ObjectMapper());
    }

    public ThunkExpression<?> decodeFromJson(JsonNode node) throws JsonProcessingException {
        return ((JsonExpressionDto)this.objectMapper.treeToValue((TreeNode)node, JsonExpressionDto.class)).toExpression();
    }

    @Deprecated(forRemoval=true, since="0.10.1")
    public ThunkExpression<Boolean> decoder(byte[] data) {
        return this.decode(data);
    }

    public ThunkExpression<Boolean> decode(byte[] data) {
        try {
            return this.decodeFromJson(this.objectMapper.readTree(data)).assertResultType(Boolean.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonNode encodeToJson(ThunkExpression<?> expression) {
        JsonExpressionDto jsonDto = (JsonExpressionDto)expression.accept((ThunkExpressionVisitor)visitor, null);
        return this.objectMapper.valueToTree((Object)jsonDto);
    }

    public byte[] encode(ThunkExpression<Boolean> expression) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)this.encodeToJson(expression));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Generated
    public JsonThunkExpressionCoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static class JsonEncoderVisitor
    extends ContextFreeThunkExpressionVisitor<JsonExpressionDto> {
        private JsonEncoderVisitor() {
        }

        public JsonExpressionDto visit(Scalar<?> scalar) {
            Class resultType = scalar.getResultType();
            String typeName = JsonScalarDto.SCALAR_TYPES.get(resultType);
            if (typeName == null) {
                String exMessage = String.format("Scalar of type <%s> is not supported", resultType.getName());
                throw new IllegalArgumentException(exMessage);
            }
            return JsonScalarDto.of(typeName, scalar.getValue());
        }

        public JsonExpressionDto visit(FunctionExpression<?> functionExpression) {
            FunctionExpression.Operator operator = functionExpression.getOperator();
            Stream<JsonExpressionDto> result = functionExpression.getTerms().stream().map(term -> (JsonExpressionDto)term.accept((ThunkExpressionVisitor)this, null));
            return new JsonFunctionDto(operator.getKey(), result);
        }

        public JsonExpressionDto visit(SymbolicReference ref) {
            List<JsonExpressionDto> jsonExprTerms = ref.getPath().stream().map(p -> (JsonExpressionDto)p.accept((ContextFreeThunkExpressionVisitor)this)).collect(Collectors.toList());
            return new JsonSymbolicReferenceDto((JsonExpressionDto)ref.getSubject().accept((ThunkExpressionVisitor)this, null), jsonExprTerms);
        }

        public JsonExpressionDto visit(Variable variable) {
            return new JsonVariableDto(variable.getName());
        }
    }
}

