/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.BooleanOperation;
import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class LogicalOperation
implements BooleanOperation {
    private final FunctionExpression.Operator operator;
    private List<ThunkExpression<Boolean>> terms;

    protected LogicalOperation(FunctionExpression.Operator operator, Stream<ThunkExpression<Boolean>> terms) {
        this.operator = operator;
        this.terms = terms.collect(Collectors.toUnmodifiableList());
    }

    public static LogicalOperation disjunction(Stream<ThunkExpression<Boolean>> terms) {
        return new LogicalOperation(FunctionExpression.Operator.OR, terms);
    }

    public static LogicalOperation disjunction(List<ThunkExpression<Boolean>> terms) {
        return LogicalOperation.disjunction(terms.stream());
    }

    public static LogicalOperation uncheckedDisjunction(List<ThunkExpression<?>> terms) {
        return LogicalOperation.disjunction(terms.stream().map(expr -> expr));
    }

    public static LogicalOperation disjunction(ThunkExpression<Boolean> ... terms) {
        return LogicalOperation.disjunction(Arrays.stream(terms));
    }

    public static LogicalOperation conjunction(Stream<ThunkExpression<Boolean>> terms) {
        return new LogicalOperation(FunctionExpression.Operator.AND, terms);
    }

    public static LogicalOperation conjunction(ThunkExpression<Boolean> ... terms) {
        return LogicalOperation.conjunction(Arrays.stream(terms));
    }

    public static LogicalOperation conjunction(List<ThunkExpression<Boolean>> terms) {
        return LogicalOperation.conjunction(terms.stream());
    }

    public static LogicalOperation uncheckedConjunction(List<ThunkExpression<?>> terms) {
        return LogicalOperation.conjunction(terms.stream().map(expr -> expr));
    }

    public static LogicalOperation uncheckedNegation(List<ThunkExpression<?>> terms) {
        if (terms.size() != 1) {
            throw new IllegalArgumentException("Expected 1 term, not " + terms.size());
        }
        return LogicalOperation.negation(terms.get(0));
    }

    public static LogicalOperation negation(ThunkExpression<Boolean> term) {
        return new LogicalOperation(FunctionExpression.Operator.NOT, Stream.of(term));
    }

    @Override
    public FunctionExpression.Operator getOperator() {
        return this.operator;
    }

    @Override
    public List<ThunkExpression<?>> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public String toString() {
        return this.toDebugString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogicalOperation)) {
            return false;
        }
        LogicalOperation other = (LogicalOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionExpression.Operator this$operator = this.getOperator();
        FunctionExpression.Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<ThunkExpression<?>> this$terms = this.getTerms();
        List<ThunkExpression<?>> other$terms = other.getTerms();
        return !(this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogicalOperation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionExpression.Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<ThunkExpression<?>> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        return result;
    }
}

