/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import java.util.Optional;

public interface ThunkExpression<T> {
    public Class<? extends T> getResultType();

    default public <R> ThunkExpression<R> assertResultType(Class<R> resultType) {
        if (resultType != this.getResultType()) {
            throw new IllegalArgumentException("Result of expression " + String.valueOf(this) + " is " + String.valueOf(this.getResultType()) + ", which does not match the asserted type " + String.valueOf(resultType) + ".");
        }
        return this;
    }

    public <R, C> R accept(ThunkExpressionVisitor<R, C> var1, C var2);

    public static <R> Optional<Scalar<R>> maybeScalar(ThunkExpression<R> expression) {
        if (expression instanceof Scalar) {
            return Optional.of((Scalar)expression);
        }
        return Optional.empty();
    }

    public static <R> Optional<R> maybeValue(ThunkExpression<R> expression) {
        if (expression.getResultType() == Void.class) {
            throw new IllegalArgumentException("Expression with result type " + String.valueOf(Void.class) + " can not be mapped with #maybeValue(), use #maybeScalar() instead.");
        }
        return ThunkExpression.maybeScalar(expression).map(Scalar::getValue);
    }
}

