/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.BooleanOperation;
import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class Comparison
implements BooleanOperation {
    @NonNull
    private final FunctionExpression.Operator operator;
    @NonNull
    private final ThunkExpression<?> leftTerm;
    @NonNull
    private final ThunkExpression<?> rightTerm;

    @Override
    public List<ThunkExpression<?>> getTerms() {
        return List.of(this.leftTerm, this.rightTerm);
    }

    public static Comparison areEqual(List<ThunkExpression<?>> terms) {
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.areEqual(terms.get(0), terms.get(1));
    }

    public static Comparison areEqual(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.EQUALS, left, right);
    }

    public static Comparison notEqual(List<ThunkExpression<?>> terms) {
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.notEqual(terms.get(0), terms.get(1));
    }

    public static Comparison notEqual(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.NOT_EQUAL_TO, left, right);
    }

    public static Comparison greater(List<ThunkExpression<?>> terms) {
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.greater(terms.get(0), terms.get(1));
    }

    public static Comparison greater(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.GREATER_THAN, left, right);
    }

    public static Comparison greaterOrEquals(List<ThunkExpression<?>> terms) {
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.greaterOrEquals(terms.get(0), terms.get(1));
    }

    public static Comparison greaterOrEquals(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.GREATER_THAN_OR_EQUAL_TO, left, right);
    }

    public static Comparison less(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.less(terms.get(0), terms.get(1));
    }

    public static Comparison less(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.LESS_THAN, left, right);
    }

    public static Comparison lessOrEquals(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        Comparison.assertTermSizeIsTwo(terms);
        return Comparison.lessOrEquals(terms.get(0), terms.get(1));
    }

    public static Comparison lessOrEquals(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new Comparison(FunctionExpression.Operator.LESS_THEN_OR_EQUAL_TO, left, right);
    }

    private static void assertTermSizeIsTwo(List<ThunkExpression<?>> terms) {
        if (terms.size() == 2) {
            return;
        }
        throw new IllegalArgumentException("Expected 2 terms, but got " + terms.size());
    }

    public String toString() {
        return this.toDebugString();
    }

    @Generated
    private Comparison(@NonNull FunctionExpression.Operator operator, @NonNull ThunkExpression<?> leftTerm, @NonNull ThunkExpression<?> rightTerm) {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (leftTerm == null) {
            throw new NullPointerException("leftTerm is marked non-null but is null");
        }
        if (rightTerm == null) {
            throw new NullPointerException("rightTerm is marked non-null but is null");
        }
        this.operator = operator;
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comparison)) {
            return false;
        }
        Comparison other = (Comparison)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionExpression.Operator this$operator = this.getOperator();
        FunctionExpression.Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        ThunkExpression<?> this$leftTerm = this.getLeftTerm();
        ThunkExpression<?> other$leftTerm = other.getLeftTerm();
        if (this$leftTerm == null ? other$leftTerm != null : !this$leftTerm.equals(other$leftTerm)) {
            return false;
        }
        ThunkExpression<?> this$rightTerm = this.getRightTerm();
        ThunkExpression<?> other$rightTerm = other.getRightTerm();
        return !(this$rightTerm == null ? other$rightTerm != null : !this$rightTerm.equals(other$rightTerm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Comparison;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionExpression.Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        ThunkExpression<?> $leftTerm = this.getLeftTerm();
        result = result * 59 + ($leftTerm == null ? 43 : $leftTerm.hashCode());
        ThunkExpression<?> $rightTerm = this.getRightTerm();
        result = result * 59 + ($rightTerm == null ? 43 : $rightTerm.hashCode());
        return result;
    }

    @Override
    @NonNull
    @Generated
    public FunctionExpression.Operator getOperator() {
        return this.operator;
    }

    @NonNull
    @Generated
    public ThunkExpression<?> getLeftTerm() {
        return this.leftTerm;
    }

    @NonNull
    @Generated
    public ThunkExpression<?> getRightTerm() {
        return this.rightTerm;
    }
}

