/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.Comparison;
import com.contentgrid.thunx.predicates.model.LogicalOperation;
import com.contentgrid.thunx.predicates.model.NumericFunction;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public interface FunctionExpression<T>
extends ThunkExpression<T> {
    public Operator getOperator();

    public List<ThunkExpression<?>> getTerms();

    @Override
    default public <R, C> R accept(ThunkExpressionVisitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    default public String toDebugString() {
        return String.format("%s(%s)", this.getOperator().getKey().toUpperCase(Locale.ROOT), this.getTerms().stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public static enum Operator {
        EQUALS("eq", Boolean.class, Comparison::areEqual),
        NOT_EQUAL_TO("neq", Boolean.class, Comparison::notEqual),
        GREATER_THAN("gt", Boolean.class, Comparison::greater),
        GREATER_THAN_OR_EQUAL_TO("gte", Boolean.class, Comparison::greaterOrEquals),
        LESS_THAN("lt", Boolean.class, Comparison::less),
        LESS_THEN_OR_EQUAL_TO("lte", Boolean.class, Comparison::lessOrEquals),
        AND("and", Boolean.class, LogicalOperation::uncheckedConjunction),
        OR("or", Boolean.class, LogicalOperation::uncheckedDisjunction),
        NOT("not", Boolean.class, LogicalOperation::uncheckedNegation),
        PLUS("plus", Number.class, NumericFunction::plus),
        MINUS("minus", Number.class, NumericFunction::minus),
        DIVIDE("div", Number.class, NumericFunction::divide),
        MULTIPLY("mul", Number.class, NumericFunction::multiply),
        MODULUS("mod", Number.class, NumericFunction::modulus);

        @NonNull
        private final String key;
        @NonNull
        private final Class<?> type;
        @NonNull
        private final FunctionExpressionFactory<?> factory;

        public static Operator resolve(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            return Arrays.stream(Operator.values()).filter(op -> Objects.equals(key, op.getKey())).findFirst().orElseThrow(() -> {
                String message = String.format("Invalid %s key: '%s'", Operator.class.getSimpleName(), key);
                return new IllegalArgumentException(message);
            });
        }

        public FunctionExpression<?> create(List<ThunkExpression<?>> terms) {
            return this.factory.create(terms);
        }

        @Generated
        private Operator(@NonNull String key, Class<?> type, FunctionExpressionFactory<?> factory) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.key = key;
            this.type = type;
            this.factory = factory;
        }

        @NonNull
        @Generated
        public String getKey() {
            return this.key;
        }

        @NonNull
        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public FunctionExpressionFactory<?> getFactory() {
            return this.factory;
        }
    }

    @FunctionalInterface
    public static interface FunctionExpressionFactory<T> {
        public FunctionExpression<T> create(List<ThunkExpression<?>> var1);
    }
}

