/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class NumericFunction
implements FunctionExpression<Number> {
    @NonNull
    private final FunctionExpression.Operator operator;
    @NonNull
    private final ThunkExpression<?> leftTerm;
    @NonNull
    private final ThunkExpression<?> rightTerm;

    @Override
    public List<ThunkExpression<?>> getTerms() {
        return List.of(this.leftTerm, this.rightTerm);
    }

    @Override
    public Class<? extends Number> getResultType() {
        return Number.class;
    }

    public static NumericFunction multiply(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new NumericFunction(FunctionExpression.Operator.MULTIPLY, left, right);
    }

    public static NumericFunction multiply(List<ThunkExpression<?>> terms) {
        if (terms.size() < 2) {
            throw new IllegalArgumentException("Expected 2 or more terms");
        }
        return terms.stream().reduce(NumericFunction::multiply).map(NumericFunction.class::cast).orElseThrow(() -> new IllegalArgumentException("Expected 1 or more terms"));
    }

    public static NumericFunction plus(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new NumericFunction(FunctionExpression.Operator.PLUS, left, right);
    }

    public static NumericFunction plus(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        if (terms.size() < 2) {
            throw new IllegalArgumentException("Expected 2 or more terms");
        }
        return terms.stream().reduce(NumericFunction::plus).map(NumericFunction.class::cast).orElseThrow(() -> new IllegalArgumentException("Expected 1 or more terms"));
    }

    public static NumericFunction divide(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Expected exactly 2 terms");
        }
        return NumericFunction.divide(terms.get(0), terms.get(1));
    }

    public static NumericFunction divide(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new NumericFunction(FunctionExpression.Operator.DIVIDE, left, right);
    }

    public static NumericFunction minus(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Expected exactly 2 terms");
        }
        return NumericFunction.minus(terms.get(0), terms.get(1));
    }

    public static NumericFunction minus(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new NumericFunction(FunctionExpression.Operator.MINUS, left, right);
    }

    public static NumericFunction modulus(@NonNull List<ThunkExpression<?>> terms) {
        if (terms == null) {
            throw new NullPointerException("terms is marked non-null but is null");
        }
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Expected exactly 2 terms");
        }
        return NumericFunction.modulus(terms.get(0), terms.get(1));
    }

    public static NumericFunction modulus(ThunkExpression<?> left, ThunkExpression<?> right) {
        return new NumericFunction(FunctionExpression.Operator.MODULUS, left, right);
    }

    @Generated
    public NumericFunction(@NonNull FunctionExpression.Operator operator, @NonNull ThunkExpression<?> leftTerm, @NonNull ThunkExpression<?> rightTerm) {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (leftTerm == null) {
            throw new NullPointerException("leftTerm is marked non-null but is null");
        }
        if (rightTerm == null) {
            throw new NullPointerException("rightTerm is marked non-null but is null");
        }
        this.operator = operator;
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Override
    @NonNull
    @Generated
    public FunctionExpression.Operator getOperator() {
        return this.operator;
    }

    @NonNull
    @Generated
    public ThunkExpression<?> getLeftTerm() {
        return this.leftTerm;
    }

    @NonNull
    @Generated
    public ThunkExpression<?> getRightTerm() {
        return this.rightTerm;
    }
}

