/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.BooleanValue;
import com.contentgrid.thunx.predicates.model.NullValue;
import com.contentgrid.thunx.predicates.model.NumberValue;
import com.contentgrid.thunx.predicates.model.StringValue;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import java.math.BigDecimal;

public interface Scalar<T>
extends ThunkExpression<T> {
    public T getValue();

    @Override
    default public <R, C> R accept(ThunkExpressionVisitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public static NumberValue of(BigDecimal number) {
        return new NumberValue(number);
    }

    public static NumberValue of(double number) {
        return Scalar.of(BigDecimal.valueOf(number));
    }

    public static NumberValue of(long number) {
        return Scalar.of(BigDecimal.valueOf(number));
    }

    public static StringValue of(String value) {
        return new StringValue(value);
    }

    public static BooleanValue of(boolean value) {
        return new BooleanValue(value);
    }

    public static NullValue nullValue() {
        return NullValue.INSTANCE;
    }
}

