/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.predicates.model;

import com.contentgrid.thunx.predicates.model.ContextFreeThunkExpressionVisitor;
import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.StringValue;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import com.contentgrid.thunx.predicates.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class SymbolicReference
implements ThunkExpression<Object> {
    private final SymbolicRefSubject subject;
    private final List<PathElement> path;

    public Variable getSubject() {
        return this.subject.getVariable();
    }

    public String toPath() {
        if (this.path.isEmpty()) {
            return this.subject.toPath();
        }
        return String.format("%s.%s", this.subject, this.path.stream().map(Object::toString).collect(Collectors.joining(".")));
    }

    public String toString() {
        if (this.path.isEmpty()) {
            return this.subject.toPath();
        }
        return String.format("%s.%s", this.subject, this.path.stream().map(Object::toString).collect(Collectors.joining(".")));
    }

    @Override
    public <R, C> R accept(ThunkExpressionVisitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public static SymbolicReference of(String variable, PathElement ... path) {
        return SymbolicReference.of(Variable.named(variable), path);
    }

    public static SymbolicReference of(Variable variable, PathElement ... path) {
        Objects.requireNonNull(variable, "variable cannot be null");
        return new SymbolicReference(new SymbolicRefSubject(variable), Arrays.asList(path));
    }

    public static SymbolicReference of(String varName, Consumer<PathBuilder> pathCallback) {
        Objects.requireNonNull(varName, "variable cannot be null");
        PathBuilder pathBuilder = new PathBuilder();
        pathCallback.accept(pathBuilder);
        return new SymbolicReference(new SymbolicRefSubject(Variable.named(varName)), pathBuilder.getPath());
    }

    public static SymbolicReference parse(String reference) {
        Objects.requireNonNull(reference, "variable cannot be null");
        String[] parts = reference.split("\\.");
        String subject = parts[0];
        return SymbolicReference.of(Variable.named(subject), Arrays.stream(parts).skip(1L).map(part -> SymbolicReference.path(part)));
    }

    public static SymbolicReference of(Variable variable, Stream<PathElement> path) {
        Objects.requireNonNull(variable, "variable cannot be null");
        return SymbolicReference.of(variable, path.collect(Collectors.toList()));
    }

    public static SymbolicReference of(Variable variable, List<PathElement> path) {
        Objects.requireNonNull(variable, "variable cannot be null");
        return new SymbolicReference(new SymbolicRefSubject(variable), path);
    }

    public static PathElement path(String path) {
        return new StringPathElement(path);
    }

    public static PathElement pathVar(String variable) {
        return new VariablePathElement(variable);
    }

    public static PathElement path(ThunkExpression<?> expr) {
        if (expr instanceof StringValue) {
            return SymbolicReference.path(((StringValue)expr).getValue());
        }
        if (expr instanceof Variable) {
            return SymbolicReference.pathVar(((Variable)expr).getName());
        }
        throw new IllegalArgumentException(String.format("Expression '%s' not supported as path element", expr));
    }

    @Override
    public Class<?> getResultType() {
        return Object.class;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymbolicReference)) {
            return false;
        }
        SymbolicReference other = (SymbolicReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Variable this$subject = this.getSubject();
        Variable other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !((Object)this$subject).equals(other$subject)) {
            return false;
        }
        List<PathElement> this$path = this.getPath();
        List<PathElement> other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SymbolicReference;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Variable $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : ((Object)$subject).hashCode());
        List<PathElement> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Generated
    public SymbolicReference(SymbolicRefSubject subject, List<PathElement> path) {
        this.subject = subject;
        this.path = path;
    }

    @Generated
    public List<PathElement> getPath() {
        return this.path;
    }

    private static class SymbolicRefSubject {
        private final Variable variable;

        public String toPath() {
            return this.variable.getName();
        }

        public String toString() {
            return this.variable.getName();
        }

        @Generated
        public SymbolicRefSubject(Variable variable) {
            this.variable = variable;
        }

        @Generated
        public Variable getVariable() {
            return this.variable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicRefSubject)) {
                return false;
            }
            SymbolicRefSubject other = (SymbolicRefSubject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Variable this$variable = this.getVariable();
            Variable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !((Object)this$variable).equals(other$variable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SymbolicRefSubject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Variable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : ((Object)$variable).hashCode());
            return result;
        }
    }

    public static interface PathElement {
        public <T> T accept(ContextFreeThunkExpressionVisitor<T> var1);
    }

    public static class PathBuilder {
        private List<PathElement> path = new ArrayList<PathElement>();

        public PathBuilder string(String path) {
            this.path.add(new StringPathElement(path));
            return this;
        }

        public PathBuilder var(String variable) {
            this.path.add(new VariablePathElement(variable));
            return this;
        }

        public List<PathElement> getPath() {
            return this.path;
        }
    }

    public static class StringPathElement
    implements PathElement {
        private final StringValue path;

        StringPathElement(String path) {
            this(new StringValue(path));
        }

        StringPathElement(StringValue path) {
            this.path = path;
        }

        public String toString() {
            return this.path.getValue();
        }

        @Override
        public <T> T accept(ContextFreeThunkExpressionVisitor<T> visitor) {
            return visitor.visit(this.getPath());
        }

        @Generated
        public StringValue getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringPathElement)) {
                return false;
            }
            StringPathElement other = (StringPathElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StringValue this$path = this.getPath();
            StringValue other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StringPathElement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StringValue $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }
    }

    public static class VariablePathElement
    implements PathElement {
        private Variable variable;

        VariablePathElement(String varName) {
            this.variable = Variable.named(varName);
        }

        public String toString() {
            return "$" + this.variable.getName();
        }

        @Override
        public <T> T accept(ContextFreeThunkExpressionVisitor<T> visitor) {
            return visitor.visit(this.getVariable());
        }

        @Generated
        public Variable getVariable() {
            return this.variable;
        }

        @Generated
        public void setVariable(Variable variable) {
            this.variable = variable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariablePathElement)) {
                return false;
            }
            VariablePathElement other = (VariablePathElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Variable this$variable = this.getVariable();
            Variable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !((Object)this$variable).equals(other$variable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VariablePathElement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Variable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : ((Object)$variable).hashCode());
            return result;
        }
    }

    public static abstract class PathElementVisitor<T>
    extends ContextFreeThunkExpressionVisitor<T> {
        @Override
        public final T visit(FunctionExpression<?> functionExpression) {
            return null;
        }

        @Override
        public final T visit(SymbolicReference symbolicReference) {
            return null;
        }
    }
}

