/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.pdp.opa;

import com.contentgrid.opa.client.OpaClient;
import com.contentgrid.opa.client.api.CompileApi;
import com.contentgrid.opa.rego.ast.QuerySet;
import com.contentgrid.thunx.pdp.PolicyDecision;
import com.contentgrid.thunx.pdp.PolicyDecisionPointClient;
import com.contentgrid.thunx.pdp.PolicyDecisions;
import com.contentgrid.thunx.pdp.opa.OpaInputProvider;
import com.contentgrid.thunx.pdp.opa.OpaQueryProvider;
import com.contentgrid.thunx.pdp.opa.QuerySetToThunkExpressionConverter;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.ThunkExpressionVisitor;
import com.contentgrid.thunx.visitor.reducer.ThunkReducerVisitor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPolicyAgentPDPClient<A, R>
implements PolicyDecisionPointClient<A, R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenPolicyAgentPDPClient.class);
    @NonNull
    private final OpaClient opaClient;
    @NonNull
    private final OpaQueryProvider<R> queryProvider;
    @NonNull
    private final OpaInputProvider<A, R> inputProvider;

    public CompletableFuture<PolicyDecision> conditional(A authContext, R requestContext) {
        CompileApi.PartialEvaluationRequest request = new CompileApi.PartialEvaluationRequest(this.queryProvider.createQuery(requestContext), this.inputProvider.createInput(authContext, requestContext), List.of("input.entity"));
        return ((CompletableFuture)this.opaClient.compile(request).thenApply(response -> {
            log.trace("Partial policy evaluation request:\n{}\nResponse:\n{}", (Object)request, response);
            QuerySet opaQuerySet = response.getResult().getQueries();
            QuerySetToThunkExpressionConverter converter = new QuerySetToThunkExpressionConverter();
            return converter.convert(opaQuerySet);
        })).thenApply(thunkExpression -> {
            ThunkExpression reducedExpression = ((ThunkExpression)thunkExpression.accept((ThunkExpressionVisitor)ThunkReducerVisitor.DEFAULT_INSTANCE, null)).assertResultType(Boolean.class);
            log.trace("Thunx expression:\n{}\nReduced to:\n{}", thunkExpression, (Object)reducedExpression);
            return ThunkExpression.maybeValue((ThunkExpression)reducedExpression).map(result -> result != false ? PolicyDecisions.allowed() : PolicyDecisions.denied()).orElse(PolicyDecisions.conditional((ThunkExpression)reducedExpression));
        });
    }

    @Generated
    public OpenPolicyAgentPDPClient(@NonNull OpaClient opaClient, @NonNull OpaQueryProvider<R> queryProvider, @NonNull OpaInputProvider<A, R> inputProvider) {
        if (opaClient == null) {
            throw new NullPointerException("opaClient is marked non-null but is null");
        }
        if (queryProvider == null) {
            throw new NullPointerException("queryProvider is marked non-null but is null");
        }
        if (inputProvider == null) {
            throw new NullPointerException("inputProvider is marked non-null but is null");
        }
        this.opaClient = opaClient;
        this.queryProvider = queryProvider;
        this.inputProvider = inputProvider;
    }
}

