/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.pdp.opa;

import com.contentgrid.opa.rego.ast.Expression;
import com.contentgrid.opa.rego.ast.Query;
import com.contentgrid.opa.rego.ast.QuerySet;
import com.contentgrid.opa.rego.ast.RegoVisitor;
import com.contentgrid.opa.rego.ast.Term;
import com.contentgrid.thunx.predicates.model.Comparison;
import com.contentgrid.thunx.predicates.model.LogicalOperation;
import com.contentgrid.thunx.predicates.model.NumericFunction;
import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.SymbolicReference;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.model.Variable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuerySetToThunkExpressionConverter {
    public ThunkExpression<Boolean> convert(QuerySet querySet) {
        if (querySet == null || querySet.size() == 0) {
            return Scalar.of((boolean)false);
        }
        Stream<ThunkExpression> queries = querySet.stream().map(this::convert);
        if (querySet.size() == 1) {
            return queries.findFirst().orElseThrow();
        }
        return LogicalOperation.disjunction(queries);
    }

    public ThunkExpression<Boolean> convert(Query query) {
        if (query.size() == 0) {
            return Scalar.of((boolean)true);
        }
        List expressions = query.stream().map(this::convert).peek(expr -> {
            if (!Boolean.class.isAssignableFrom(expr.getResultType())) {
                String msg = String.format("Expected boolean expression, but was of type %s", expr.getResultType().getSimpleName());
                throw new UnsupportedOperationException(msg);
            }
        }).map(expr -> expr).collect(Collectors.toList());
        if (expressions.size() == 1) {
            return (ThunkExpression)expressions.get(0);
        }
        return LogicalOperation.conjunction(expressions);
    }

    ThunkExpression<?> convert(Expression expression) {
        ThunkExpression expr = (ThunkExpression)expression.accept((RegoVisitor)new PredicatesVisitor());
        return expr;
    }

    static class PredicatesVisitor
    implements RegoVisitor<ThunkExpression<?>> {
        private static Map<String, Function<List<ThunkExpression<?>>, ThunkExpression<?>>> OPERATION_LOOKUP = Map.ofEntries(Map.entry("mul", NumericFunction::multiply), Map.entry("eq", Comparison::areEqual), Map.entry("neq", Comparison::notEqual), Map.entry("gt", Comparison::greater), Map.entry("gte", Comparison::greaterOrEquals), Map.entry("lt", Comparison::less), Map.entry("lte", Comparison::lessOrEquals));

        PredicatesVisitor() {
        }

        public ThunkExpression<?> visit(QuerySet queries) {
            throw new UnsupportedOperationException();
        }

        public ThunkExpression<?> visit(Query query) {
            throw new UnsupportedOperationException();
        }

        public ThunkExpression<?> visit(Expression expression) {
            if (expression.getTerms().isEmpty()) {
                throw new IllegalArgumentException("expression is empty");
            }
            Term firstTerm = (Term)expression.getTerms().get(0);
            ThunkExpression firstExpr = (ThunkExpression)firstTerm.accept((RegoVisitor)this);
            if (expression.getTerms().size() == 1) {
                return firstExpr;
            }
            if (firstExpr instanceof SymbolicReference) {
                String functionName = ((SymbolicReference)firstExpr).toPath();
                List args = expression.getTerms().stream().skip(1L).map(t -> (ThunkExpression)t.accept((RegoVisitor)this)).collect(Collectors.toList());
                Function<List<ThunkExpression<?>>, ThunkExpression<?>> operation = OPERATION_LOOKUP.get(functionName);
                if (operation != null) {
                    return operation.apply(args);
                }
                throw new UnsupportedOperationException("operation " + functionName + " not supported");
            }
            String msg = "cannot translate fields in top level expression (index:" + expression.getIndex() + ") into a proper predicate:" + expression.getTerms().stream().map(term -> term.getClass().getName()).collect(Collectors.joining(","));
            throw new UnsupportedOperationException(msg);
        }

        public ThunkExpression<?> visit(Term.Ref ref) {
            if (ref.getValue().isEmpty()) {
                throw new IllegalArgumentException("ref has no values");
            }
            ThunkExpression subject = (ThunkExpression)((Term)ref.getValue().get(0)).accept((RegoVisitor)this);
            if (subject instanceof Variable) {
                SymbolicReference symbol = SymbolicReference.of((Variable)((Variable)subject), ref.getValue().stream().skip(1L).map(val -> {
                    if (val instanceof Term.Text) {
                        return SymbolicReference.path((String)((Term.Text)val).getValue());
                    }
                    if (val instanceof Term.Var) {
                        return SymbolicReference.pathVar((String)((Term.Var)val).getValue());
                    }
                    String msg = String.format("ref-arg of type %s not implemented", val.getClass().getName());
                    throw new RuntimeException(msg);
                }));
                List path = symbol.getPath();
                if ("input".equalsIgnoreCase(symbol.getSubject().getName())) {
                    symbol = symbol.getPath().stream().findFirst().filter(first -> first instanceof SymbolicReference.StringPathElement).filter(first -> "entity".equalsIgnoreCase(first.toString())).map(first -> SymbolicReference.of((Variable)Variable.named((String)"entity"), path.stream().skip(1L))).orElse(symbol);
                }
                return symbol;
            }
            String message = String.format("symbolic ref for <%s> not implemented", subject.getClass().getName());
            throw new UnsupportedOperationException(message);
        }

        public ThunkExpression<?> visit(Term.Call call) {
            throw new UnsupportedOperationException();
        }

        public ThunkExpression<?> visit(Term.Var var) {
            return Variable.named((String)var.getValue());
        }

        public ThunkExpression<?> visit(Term.Numeric numeric) {
            return Scalar.of((BigDecimal)numeric.getValue());
        }

        public ThunkExpression<?> visit(Term.Text stringValue) {
            return Scalar.of((String)stringValue.getValue());
        }

        public ThunkExpression<?> visit(Term.Bool value) {
            return Scalar.of((boolean)value.getValue());
        }

        public ThunkExpression<?> visit(Term.Null nullValue) {
            return Scalar.nullValue();
        }

        public ThunkExpression<?> visit(Term.ArrayTerm arrayTerm) {
            throw new UnsupportedOperationException();
        }

        public ThunkExpression<?> visit(Term.SetTerm setTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

