/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.spring.data.querydsl;

import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.predicates.querydsl.FieldByReflectionAccessStrategy;
import com.contentgrid.thunx.predicates.querydsl.PathBuilderFactory;
import com.contentgrid.thunx.predicates.querydsl.PropertyAccessStrategy;
import com.contentgrid.thunx.predicates.querydsl.QueryDslConverter;
import com.contentgrid.thunx.spring.data.context.AbacContextSupplier;
import com.contentgrid.thunx.spring.data.querydsl.AllOperationPredicates;
import com.contentgrid.thunx.spring.data.querydsl.EntityPathResolverBasedPathBuilderFactory;
import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.OperationPredicates;
import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.QuerydslPredicateResolver;
import com.querydsl.core.types.Predicate;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.util.Assert;

public class AbacQuerydslPredicateResolver
implements QuerydslPredicateResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbacQuerydslPredicateResolver.class);
    private final QueryDslConverter queryDslConverter;
    private final AbacContextSupplier abacContextSupplier;

    public AbacQuerydslPredicateResolver(EntityPathResolver resolver, AbacContextSupplier abacContextSupplier) {
        this.queryDslConverter = new QueryDslConverter((PropertyAccessStrategy)new FieldByReflectionAccessStrategy(), (PathBuilderFactory)new EntityPathResolverBasedPathBuilderFactory(resolver));
        this.abacContextSupplier = abacContextSupplier;
    }

    public Optional<OperationPredicates> resolve(MethodParameter methodParameter, Class<?> domainType, Map<String, String[]> parameters) {
        ThunkExpression<Boolean> abacContext = this.abacContextSupplier.getAbacContext();
        if (abacContext != null) {
            Predicate queryDslPredicate = this.queryDslConverter.from(abacContext, domainType);
            Assert.notNull((Object)queryDslPredicate, (String)"abac expression cannot be null");
            log.debug("ABAC Querydsl Predicate: {}", (Object)queryDslPredicate);
            return Optional.of(new AllOperationPredicates(queryDslPredicate));
        }
        return Optional.empty();
    }
}

