/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.spring.data.rest;

import com.contentgrid.thunx.spring.data.querydsl.predicate.injector.resolver.OperationPredicates;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslRepositoryInvokerAdapter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

class AbacRepositoryInvokerAdapter
extends QuerydslRepositoryInvokerAdapter {
    @NonNull
    private final QuerydslPredicateExecutor<Object> executor;
    @NonNull
    private final OperationPredicates predicate;
    private final PlatformTransactionManager transactionManager;
    @NonNull
    private final Class<?> idPropertyType;
    @NonNull
    private final String idName;
    @NonNull
    private final Function<Object, Optional<?>> idFunction;
    @NonNull
    private final PathBuilder<?> pathBuilder;
    private final ConversionService conversionService;

    public AbacRepositoryInvokerAdapter(RepositoryInvoker delegate, QuerydslPredicateExecutor<Object> executor, OperationPredicates predicate, PlatformTransactionManager transactionManager, RepositoryMetadata repositoryMetadata, PersistentEntity<?, ?> persistentEntity, EntityInformation<Object, ?> entityInformation, PathBuilder<?> pathBuilder, ConversionService conversionService) {
        this(delegate, executor, predicate, transactionManager, repositoryMetadata.getIdType(), persistentEntity.getRequiredIdProperty().getName(), (Object entity) -> Optional.ofNullable(entityInformation.getId(entity)), pathBuilder, conversionService);
    }

    public AbacRepositoryInvokerAdapter(RepositoryInvoker delegate, QuerydslPredicateExecutor<Object> executor, OperationPredicates predicate, PlatformTransactionManager transactionManager, Class<?> idType, String idPropertyName, Function<Object, Optional<?>> idFunction, PathBuilder<?> pathBuilder, ConversionService conversionService) {
        super(delegate, executor, (Predicate)predicate.collectionFilterPredicate().orElse(new BooleanBuilder()));
        this.executor = executor;
        this.predicate = predicate;
        this.transactionManager = transactionManager;
        this.idPropertyType = idType;
        this.idName = idPropertyName;
        this.idFunction = idFunction;
        this.pathBuilder = pathBuilder;
        this.conversionService = conversionService;
    }

    public <T> Optional<T> invokeFindById(Object id) {
        return this.invokeFindById(id, this.predicate.readPredicate());
    }

    private <T> Optional<T> invokeFindById(Object id, Optional<Predicate> predicate) {
        BooleanBuilder builder = new BooleanBuilder();
        predicate.ifPresent(arg_0 -> ((BooleanBuilder)builder).and(arg_0));
        PathBuilder entityIdPath = this.pathBuilder.get(this.idName, this.idPropertyType);
        Assert.notNull((Object)entityIdPath, (String)"id expression cannot be null");
        builder.and((Predicate)entityIdPath.eq(Expressions.constant((Object)this.convertId(id))));
        return this.executor.findOne(Objects.requireNonNull(builder.getValue()));
    }

    protected Object convertId(Object id) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        if (this.idPropertyType.isInstance(id)) {
            return id;
        }
        Object result = this.conversionService.convert(id, this.idPropertyType);
        if (result == null) {
            throw new IllegalStateException(String.format("Identifier conversion of %s to %s unexpectedly returned null", id, this.idPropertyType));
        }
        return result;
    }

    public <T> T invokeSave(T object) {
        T entityToReturn;
        TransactionStatus status = null;
        try {
            Optional postSavePredicate;
            Optional<?> maybePreSaveId;
            if (this.transactionManager != null) {
                status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            }
            if ((maybePreSaveId = this.idFunction.apply(object)).isPresent()) {
                Object preSaveId = maybePreSaveId.get();
                if (super.invokeFindById(preSaveId).isPresent()) {
                    if (this.invokeFindById(preSaveId, this.predicate.beforeUpdatePredicate()).isEmpty()) {
                        throw new ResourceNotFoundException(String.format("id: %s", preSaveId));
                    }
                    postSavePredicate = this.predicate.afterUpdatePredicate();
                } else {
                    postSavePredicate = this.predicate.afterCreatePredicate();
                }
            } else {
                postSavePredicate = this.predicate.afterCreatePredicate();
            }
            Object savedEntity = super.invokeSave(object);
            Object id = this.idFunction.apply(savedEntity).orElseThrow();
            Optional<T> fetchedEntity = this.invokeFindById(id, postSavePredicate);
            if (fetchedEntity.isEmpty()) {
                throw new ResourceNotFoundException(String.format("id: %s", id));
            }
            entityToReturn = fetchedEntity.get();
            if (status != null && !status.isCompleted()) {
                this.transactionManager.commit(status);
            }
        }
        catch (Exception e) {
            if (status != null && !status.isCompleted()) {
                this.transactionManager.rollback(status);
            }
            throw e;
        }
        return entityToReturn;
    }

    public void invokeDeleteById(Object id) {
        if (this.invokeFindById(id, this.predicate.beforeDeletePredicate()).isEmpty()) {
            throw new ResourceNotFoundException(String.format("id: %s", id));
        }
        super.invokeDeleteById(id);
    }
}

