/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.spring.data.rest;

import com.contentgrid.thunx.encoding.ThunkExpressionDecoder;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.spring.data.rest.AbacContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbacRequestFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbacRequestFilter.class);
    private final ThunkExpressionDecoder thunkDecoder;

    public AbacRequestFilter(ThunkExpressionDecoder thunkDecoder) {
        this.thunkDecoder = thunkDecoder;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String abacContext = request.getHeader("X-ABAC-Context");
        if (abacContext == null) {
            throw new IllegalArgumentException("No X-ABAC-Context context present.");
        }
        byte[] abacContextBytes = Base64.getDecoder().decode(abacContext);
        ThunkExpression abacExpression = this.thunkDecoder.decode(abacContextBytes);
        log.debug("ABAC Context: {}", (Object)abacExpression);
        AbacContext.setCurrentAbacContext((ThunkExpression<Boolean>)abacExpression);
        filterChain.doFilter(servletRequest, servletResponse);
        AbacContext.clear();
    }
}

