/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.visitor.reducer;

import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.visitor.reducer.FunctionReducer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

class ComparisonFunctionReducer
implements FunctionReducer<Boolean> {
    private final ComparisonFunction comparisonFunction;

    @Override
    public Optional<ThunkExpression<Boolean>> tryReduce(List<ThunkExpression<?>> values) {
        if (values.size() != 2) {
            throw new IllegalArgumentException("Comparison functions require exactly 2 parameters, received " + values.size() + " parameters.");
        }
        List availableValues = values.stream().map(ThunkExpression::maybeScalar).collect(Collectors.toList());
        if (availableValues.stream().allMatch(Optional::isPresent)) {
            List unwrappedValues = availableValues.stream().map(Optional::get).map(Scalar::getValue).collect(Collectors.toList());
            return Optional.of(Scalar.of((boolean)this.comparisonFunction.eval(unwrappedValues.get(0), unwrappedValues.get(1))));
        }
        return Optional.empty();
    }

    @Generated
    public ComparisonFunctionReducer(ComparisonFunction comparisonFunction) {
        this.comparisonFunction = comparisonFunction;
    }

    @FunctionalInterface
    public static interface ComparisonFunction {
        public boolean eval(Object var1, Object var2);
    }
}

