/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.thunx.visitor.reducer;

import com.contentgrid.thunx.predicates.model.FunctionExpression;
import com.contentgrid.thunx.predicates.model.Scalar;
import com.contentgrid.thunx.predicates.model.ThunkExpression;
import com.contentgrid.thunx.visitor.reducer.FunctionReducer;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

class LogicalFunctionReducer
implements FunctionReducer<Boolean> {
    private final Boolean forcingTerm;
    private final Boolean identityTerm;
    private final FunctionExpression.FunctionExpressionFactory<Boolean> factory;

    @Override
    public Optional<ThunkExpression<Boolean>> tryReduce(List<ThunkExpression<?>> values) {
        boolean hasForcingTerm = values.stream().map(expression -> expression.assertResultType(Boolean.class)).flatMap(e -> ThunkExpression.maybeScalar((ThunkExpression)e).stream()).map(Scalar::getValue).anyMatch(Predicate.isEqual(this.forcingTerm));
        if (hasForcingTerm) {
            return Optional.of(Scalar.of((boolean)this.forcingTerm));
        }
        List withoutIdentityTerms = values.stream().filter(e -> ThunkExpression.maybeScalar((ThunkExpression)e).map(Scalar::getValue).filter(Predicate.isEqual(this.identityTerm)).isEmpty()).collect(Collectors.toList());
        switch (withoutIdentityTerms.size()) {
            case 0: {
                return Optional.of(Scalar.of((boolean)this.identityTerm));
            }
            case 1: {
                return Optional.of((ThunkExpression)withoutIdentityTerms.get(0));
            }
        }
        return Optional.of(this.factory.create(withoutIdentityTerms));
    }

    @Generated
    public LogicalFunctionReducer(Boolean forcingTerm, Boolean identityTerm, FunctionExpression.FunctionExpressionFactory<Boolean> factory) {
        this.forcingTerm = forcingTerm;
        this.identityTerm = identityTerm;
        this.factory = factory;
    }
}

