/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.FetchAssetsCallback;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class AssetLibrary
implements INotifyClass {
    protected static final Logger logger = Logger.getLogger(AssetLibrary.class.getSimpleName());
    protected final JSONObject urlQueries = new JSONObject();
    protected Stack stackInstance;
    protected LinkedHashMap<String, Object> headers;
    protected FetchAssetsCallback callback;
    protected int count;

    protected AssetLibrary() {
    }

    protected void setStackInstance(@NotNull Stack stack) {
        this.stackInstance = stack;
        this.headers = stack.headers;
    }

    public void setHeader(@NotNull String headerKey, @NotNull String headerValue) {
        this.headers.put(headerKey, headerValue);
    }

    public void removeHeader(@NotNull String headerKey) {
        if (!headerKey.isEmpty()) {
            this.headers.remove(headerKey);
        }
    }

    public AssetLibrary sort(String keyOrderBy, ORDERBY orderby) {
        if (orderby == ORDERBY.ASCENDING) {
            this.urlQueries.put("asc", (Object)keyOrderBy);
        } else {
            this.urlQueries.put("desc", (Object)keyOrderBy);
        }
        return this;
    }

    public AssetLibrary includeCount() {
        this.urlQueries.put("include_count", (Object)"true");
        return this;
    }

    public AssetLibrary includeRelativeUrl() {
        this.urlQueries.put("relative_urls", (Object)"true");
        return this;
    }

    public AssetLibrary includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void fetchAll(FetchAssetsCallback callback) {
        this.callback = callback;
        this.urlQueries.put("environment", this.headers.get("environment"));
        this.fetchFromNetwork("assets", this.urlQueries, this.headers, callback);
    }

    private void fetchFromNetwork(String url, JSONObject urlQueries, LinkedHashMap<String, Object> headers, FetchAssetsCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, this.stackInstance, "getAllAssets", url, headers, urlParams, Constants.REQUEST_CONTROLLER.ASSETLIBRARY.toString(), (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = urlQueriesJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    @Override
    public void getResult(Object object, String controller) {
        logger.warning("No implementation required");
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        if (jsonObject != null && jsonObject.has("count")) {
            this.count = jsonObject.optInt("count");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        if (objects != null && !objects.isEmpty()) {
            for (Object object : objects) {
                AssetModel model = (AssetModel)object;
                Asset asset = this.stackInstance.asset();
                asset.contentType = model.contentType;
                asset.fileSize = model.fileSize;
                asset.uploadUrl = model.uploadUrl;
                asset.fileName = model.fileName;
                asset.json = model.json;
                asset.assetUid = model.uploadedUid;
                asset.setTags(model.tags);
                assets.add(asset);
            }
        }
        if (this.callback != null) {
            this.callback.onRequestFinish(ResponseType.NETWORK, assets);
        }
    }

    public static enum ORDERBY {
        ASCENDING,
        DESCENDING;

    }
}

