/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.AssetsModel;
import com.contentstack.sdk.CSHttpConnection;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.ContentTypesModel;
import com.contentstack.sdk.EntriesModel;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.EntryResultCallBack;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.FetchResultCallback;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.SyncResultCallBack;
import com.contentstack.sdk.SyncStack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONObject;

class CSConnectionRequest
implements IRequestModelHTTP {
    private String urlToCall;
    private CSAppConstants.RequestMethod method;
    private String controller;
    private JSONObject paramsJSON;
    private LinkedHashMap<String, Object> header;
    private HashMap<String, Object> urlQueries;
    private String requestInfo;
    private ResultCallBack callBackObject;
    private CSHttpConnection connection;
    private JSONObject responseJSON;
    private INotifyClass notifyClass;
    private INotifyClass assetLibrary;
    private Entry entryInstance;
    private Query queryInstance;
    private Asset assetInstance;
    private Stack stackInstance;
    private ContentType contentType;
    private JSONObject errorJObject;
    private Error errorObject = new Error();

    public CSConnectionRequest() {
    }

    public CSConnectionRequest(Query queryInstance) {
        this.notifyClass = queryInstance;
    }

    public CSConnectionRequest(Entry entryInstance) {
        this.entryInstance = entryInstance;
    }

    public CSConnectionRequest(INotifyClass assetLibrary) {
        this.assetLibrary = assetLibrary;
    }

    public CSConnectionRequest(Asset asset) {
        this.assetInstance = asset;
    }

    public CSConnectionRequest(Stack stack) {
        this.stackInstance = stack;
    }

    public CSConnectionRequest(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setQueryInstance(Query queryInstance) {
        this.queryInstance = queryInstance;
    }

    public void setURLQueries(HashMap<String, Object> urlQueries) {
        this.urlQueries = urlQueries;
    }

    public void setStackInstance(Stack stackInstance) {
        this.stackInstance = stackInstance;
    }

    public void setParams(Object ... objects) {
        this.urlToCall = (String)objects[0];
        this.method = (CSAppConstants.RequestMethod)((Object)objects[1]);
        this.controller = (String)objects[2];
        this.paramsJSON = (JSONObject)objects[3];
        this.header = (LinkedHashMap)objects[4];
        if (objects[5] != null) {
            this.requestInfo = (String)objects[5];
        }
        if (objects[6] != null) {
            this.callBackObject = (ResultCallBack)objects[6];
        }
        this.sendRequest();
    }

    @Override
    public void sendRequest() {
        this.connection = new CSHttpConnection(this.urlToCall, this);
        this.connection.setController(this.controller);
        this.connection.setHeaders(this.header);
        this.connection.setInfo(this.requestInfo);
        this.connection.setFormParamsPOST(this.paramsJSON);
        this.connection.setCallBackObject(this.callBackObject);
        if (this.urlQueries != null && this.urlQueries.size() > 0) {
            this.connection.setFormParams(this.urlQueries);
        }
        this.connection.setRequestMethod(this.method);
        this.connection.send();
    }

    @Override
    public void onRequestFailed(JSONObject error, int statusCode, ResultCallBack callBackObject) {
        String errMsg = "";
        int errCode = 0;
        Object errors = null;
        if (error != null && !error.isEmpty()) {
            if (error.has("error_message")) {
                errMsg = error.optString("error_message");
            }
            if (error.has("error_code")) {
                errCode = error.optInt("error_code");
            }
            if (error.has("errors") && error.opt("errors") instanceof JSONObject) {
                JSONObject errorsJsonObj = error.optJSONObject("errors");
                Iterator iterator = errorsJsonObj.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = errorsJsonObj.opt(key);
                    this.errorObject.setErrorDetail(error.get("errors").toString());
                }
            }
        }
        this.errorObject.setErrorCode(errCode);
        this.errorObject.setErrorMessage(errMsg);
        this.errorObject.setErrorDetail(error.get("errors").toString());
        if (this.callBackObject != null) {
            this.callBackObject.onRequestFail(ResponseType.NETWORK, this.errorObject);
        }
    }

    @Override
    public void onRequestFinished(CSHttpConnection request) {
        this.responseJSON = request.getResponse();
        String controller = request.getController();
        if (controller.equalsIgnoreCase("getQueryEntries")) {
            EntriesModel model = new EntriesModel(this.responseJSON, null, false);
            this.notifyClass.getResult(model.formName, null);
            this.notifyClass.getResultObject(model.objectList, this.responseJSON, false);
            model = null;
        } else if (controller.equalsIgnoreCase("getSingleQueryEntries")) {
            EntriesModel model = new EntriesModel(this.responseJSON, null, false);
            this.notifyClass.getResult(model.formName, null);
            this.notifyClass.getResultObject(model.objectList, this.responseJSON, true);
            model = null;
        } else if (controller.equalsIgnoreCase("getEntry")) {
            EntryModel model = new EntryModel(this.responseJSON, null, false, false, false);
            this.entryInstance.resultJson = model.jsonObject;
            this.entryInstance.ownerEmailId = model.ownerEmailId;
            this.entryInstance.ownerUid = model.ownerUid;
            this.entryInstance.title = model.title;
            this.entryInstance.url = model.url;
            this.entryInstance.language = model.language;
            if (model.ownerMap != null) {
                this.entryInstance.owner = new HashMap<String, Object>(model.ownerMap);
            }
            if (model._metadata != null) {
                this.entryInstance._metadata = new HashMap<String, Object>(model._metadata);
            }
            this.entryInstance.uid = model.entryUid;
            this.entryInstance.setTags(model.tags);
            model = null;
            if (request.getCallBackObject() != null) {
                ((EntryResultCallBack)request.getCallBackObject()).onRequestFinish(ResponseType.NETWORK);
            }
        } else if (controller.equalsIgnoreCase("getAllAssets")) {
            AssetsModel assetsModel = new AssetsModel(this.responseJSON, false);
            List<Object> objectList = assetsModel.objects;
            assetsModel = null;
            this.assetLibrary.getResultObject(objectList, this.responseJSON, false);
        } else if (controller.equalsIgnoreCase("getAssets")) {
            AssetModel model = new AssetModel(this.responseJSON, false, false);
            this.assetInstance.contentType = model.contentType;
            this.assetInstance.fileSize = model.fileSize;
            this.assetInstance.uploadUrl = model.uploadUrl;
            this.assetInstance.fileName = model.fileName;
            this.assetInstance.json = model.json;
            this.assetInstance.assetUid = model.uploadedUid;
            this.assetInstance.setTags(model.tags);
            model = null;
            if (request.getCallBackObject() != null) {
                ((FetchResultCallback)request.getCallBackObject()).onRequestFinish(ResponseType.NETWORK);
            }
        } else if (controller.equalsIgnoreCase("getSync")) {
            SyncStack model = new SyncStack();
            model.setJSON(this.responseJSON);
            if (request.getCallBackObject() != null) {
                ((SyncResultCallBack)request.getCallBackObject()).onRequestFinish(model);
            }
        } else if (controller.equalsIgnoreCase("getContentTypes")) {
            ContentTypesModel model = new ContentTypesModel();
            model.setJSON(this.responseJSON);
            if (request.getCallBackObject() != null) {
                ((ContentTypesCallback)request.getCallBackObject()).onRequestFinish(model);
            }
        }
    }
}

