/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import org.json.JSONArray;
import org.json.JSONObject;

class AssetModel {
    String uploadedUid;
    String contentType;
    String fileSize;
    String fileName;
    String uploadUrl;
    String[] tags;
    JSONObject json;
    int count = 0;
    int totalCount = 0;

    public AssetModel(JSONObject response, boolean isArray) {
        this.json = isArray ? response : response.optJSONObject("asset");
        if (this.json != null) {
            this.uploadedUid = (String)this.json.opt("uid");
            this.contentType = (String)this.json.opt("content_type");
            this.fileSize = (String)this.json.opt("file_size");
            this.fileName = (String)this.json.opt("filename");
            this.uploadUrl = (String)this.json.opt("url");
            if (this.json.opt("tags") instanceof JSONArray) {
                this.extractTags();
            }
            if (response.has("count")) {
                this.count = response.optInt("count");
            }
            if (response.has("objects")) {
                this.totalCount = response.optInt("objects");
            }
        }
    }

    private void extractTags() {
        JSONArray tagsArray;
        JSONArray tagArray = this.json.optJSONArray("tags");
        if (tagArray != null && !tagArray.isEmpty() && (tagsArray = (JSONArray)this.json.opt("tags")).length() > 0) {
            int counter = tagsArray.length();
            this.tags = new String[counter];
            for (int i = 0; i < counter; ++i) {
                this.tags[i] = (String)tagsArray.opt(i);
            }
        }
    }
}

