/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class ContentType {
    protected static final Logger logger = Logger.getLogger(ContentType.class.getSimpleName());
    protected String contentTypeUid;
    protected Stack stackInstance = null;
    protected LinkedHashMap<String, Object> headers = null;

    protected ContentType() throws IllegalAccessException {
        throw new IllegalAccessException("Can Not Access Private Modifier");
    }

    protected ContentType(String contentTypeUid) {
        this.contentTypeUid = contentTypeUid;
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.headers = stack.headers;
    }

    public void setHeader(String headerKey, String headerValue) {
        if (!headerKey.isEmpty() && !headerValue.isEmpty()) {
            this.headers.put(headerKey, headerValue);
        }
    }

    public void removeHeader(String headerKey) {
        if (!headerKey.isEmpty()) {
            this.headers.remove(headerKey);
        }
    }

    public Entry entry(String entryUid) {
        Entry entry = new Entry(this.contentTypeUid);
        entry.setContentType(this, this.headers);
        entry.setUid(entryUid);
        return entry;
    }

    protected Entry entry() {
        Entry entry = new Entry(this.contentTypeUid);
        entry.headers = this.headers;
        entry.setContentType(this, this.headers);
        return entry;
    }

    public Query query() {
        Query query = new Query(this.contentTypeUid);
        query.headers = this.headers;
        query.setContentTypeInstance(this);
        return query;
    }

    public void fetch(@NotNull JSONObject params, ContentTypesCallback callback) throws IllegalAccessException {
        String urlString = "content_types/" + this.contentTypeUid;
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = params.opt(key);
            params.put(key, value);
        }
        params.put("environment", this.headers.get("environment"));
        if (this.contentTypeUid == null || this.contentTypeUid.isEmpty()) {
            throw new IllegalAccessException("contentTypeUid is required");
        }
        this.fetchContentTypes(urlString, params, this.headers, callback);
    }

    private void fetchContentTypes(String urlString, JSONObject params, HashMap<String, Object> headers, ContentTypesCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(params);
            new CSBackgroundTask(this, this.stackInstance, "getContentTypes", urlString, headers, urlParams, Constants.REQUEST_CONTROLLER.CONTENTTYPES.toString(), (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator itStr = urlQueriesJSON.keys();
            while (itStr.hasNext()) {
                String key = (String)itStr.next();
                Object value = urlQueriesJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }
}

